/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.web.fileserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.web.fileserver.util.MediaTypeGuesser;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.commons.util.dirbrowser.PathNode;

@Provider
public class PathNodeWriter
implements MessageBodyWriter<PathNode> {
    public static final String MAX_AGE = "max-age";
    private final Logger logger = LoggerFactory.getLogger(PathNodeWriter.class);
    private String cacheControlHeaderValue;

    protected void activate(ComponentContext context) {
        this.cacheControlHeaderValue = "max-age=" + (String)context.getProperties().get(MAX_AGE);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return PathNode.class.isAssignableFrom(type);
    }

    public long getSize(PathNode t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.getLength();
    }

    public void writeTo(PathNode t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MediaType guessedMediaType;
        this.logger.debug("Invoked with media type: {}", (Object)mediaType);
        this.logger.debug("Invoked with pathnode: {}", (Object)t);
        if (mediaType.equals((Object)MediaType.APPLICATION_OCTET_STREAM_TYPE) && (guessedMediaType = MediaTypeGuesser.getInstance().guessTypeForName(t.getPath())) != null) {
            httpHeaders.putSingle((Object)"Content-Type", (Object)guessedMediaType);
            this.logger.debug("Set media-type to: {}", (Object)guessedMediaType);
        }
        if (!httpHeaders.containsKey((Object)"Cache-Control")) {
            httpHeaders.putSingle((Object)"Cache-Control", (Object)this.cacheControlHeaderValue);
        } else {
            this.logger.debug("httpHeaders already contain CACHE_CONTROL");
        }
        InputStream in = t.getInputStream();
        int ch = in.read();
        while (ch != -1) {
            entityStream.write(ch);
            ch = in.read();
        }
    }
}

