/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class IteratorMerger<T>
implements Iterator<T> {
    protected Iterator<Iterator<T>> baseIterators;
    protected Iterator<T> current;

    public IteratorMerger(Iterator<Iterator<T>> baseIterators) {
        this.init(baseIterators);
    }

    public IteratorMerger(Iterator<T> ... baseIterators) {
        this.init(Arrays.asList(baseIterators).iterator());
    }

    public IteratorMerger(Collection<Collection<T>> collectionOfCollections) {
        final Iterator<Collection<T>> setIter = collectionOfCollections.iterator();
        this.init(new Iterator<Iterator<T>>(){

            @Override
            public boolean hasNext() {
                return setIter.hasNext();
            }

            @Override
            public Iterator<T> next() {
                return ((Collection)setIter.next()).iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
    }

    private void init(Iterator<Iterator<T>> baseIterators) {
        this.baseIterators = baseIterators;
        this.current = baseIterators.hasNext() ? baseIterators.next() : new ArrayList(0).iterator();
    }

    private void updateCurrentIfNeeded() {
        while (!this.current.hasNext()) {
            if (this.baseIterators.hasNext()) {
                this.current = this.baseIterators.next();
                continue;
            }
            return;
        }
    }

    @Override
    public boolean hasNext() {
        this.updateCurrentIfNeeded();
        return this.current.hasNext();
    }

    @Override
    public T next() {
        this.updateCurrentIfNeeded();
        return this.current.next();
    }

    @Override
    public void remove() {
        this.current.remove();
    }
}

