/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.generic;

import com.jgoodies.looks.plastic.PlasticButtonUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.apache.cayenne.modeler.util.CayenneAction;

public class GenericButtonUI
extends PlasticButtonUI {
    private static final GenericButtonUI INSTANCE = new GenericButtonUI();
    private static final Border BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
    private static final Border DISABLED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
    private static final Border ACTIVE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0x333333)), BorderFactory.createEmptyBorder(4, 4, 4, 4)));

    public static ComponentUI createUI(JComponent b) {
        return INSTANCE;
    }

    public void installDefaults(final AbstractButton b) {
        super.installDefaults(b);
        b.putClientProperty("Plastic.is3D", Boolean.FALSE);
        if (b instanceof CayenneAction.CayenneToolbarButton) {
            b.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    b.getModel().setArmed(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    b.getModel().setArmed(false);
                }
            });
        }
    }

    public void update(Graphics g, JComponent c) {
        if (c instanceof CayenneAction.CayenneToolbarButton) {
            AbstractButton b = (AbstractButton)c;
            if (!b.isEnabled()) {
                b.setBorder(DISABLED_BORDER);
            } else if (b.getModel().isArmed()) {
                b.setBorder(ACTIVE_BORDER);
            } else {
                b.setBorder(BORDER);
            }
        }
        super.update(g, c);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Dimension size = b.getSize();
            g.setColor(this.getSelectColor());
            if (b instanceof CayenneAction.CayenneToolbarButton) {
                g.fillRect(1, 1, size.width - 2, size.height - 2);
            } else {
                g.fillRect(0, 0, size.width, size.height);
            }
        }
    }
}

