/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.generic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.cayenne.modeler.init.platform.PlatformInitializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericPlatformInitializer
implements PlatformInitializer {
    private static Log logger = LogFactory.getLog(GenericPlatformInitializer.class);
    static final String DEFAULT_LAF_NAME = PlasticXPLookAndFeel.class.getName();
    static final String DEFAULT_THEME_NAME = "Sky Bluer";

    public void setupMenus(JFrame frame) {
    }

    public void initLookAndFeel() {
        PlasticTheme theme = this.findTheme();
        if (theme != null) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)theme);
        }
        try {
            UIManager.setLookAndFeel(DEFAULT_LAF_NAME);
        }
        catch (Exception e) {
            logger.warn((Object)("Error installing L&F: " + DEFAULT_LAF_NAME), (Throwable)e);
        }
    }

    protected PlasticTheme findTheme() {
        for (Object object : PlasticLookAndFeel.getInstalledThemes()) {
            PlasticTheme theme = (PlasticTheme)object;
            if (!DEFAULT_THEME_NAME.equals(theme.getName())) continue;
            return theme;
        }
        return null;
    }
}

