/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.dba.derby.DerbyAdapter;
import org.apache.cayenne.dba.h2.H2Adapter;
import org.apache.cayenne.dba.hsqldb.HSQLDBAdapter;
import org.apache.cayenne.dba.sqlite.SQLiteAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.unit.di.server.ConnectionProperties;
import org.apache.cayenne.unit.testcontainers.TestContainerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class ServerCaseDataSourceInfoProvider
implements Provider<DataSourceInfo> {
    private static Logger logger = LoggerFactory.getLogger(ServerCaseDataSourceInfoProvider.class);
    private static final String PROPERTIES_FILE = "connection.properties";
    private static final String CONNECTION_NAME_KEY = "cayenneTestConnection";
    private static final String CONNECTION_DB_VERSION = "cayenneTestDbVersion";
    private static final String ADAPTER_KEY_MAVEN = "cayenneAdapter";
    private static final String USER_NAME_KEY_MAVEN = "cayenneJdbcUsername";
    private static final String PASSWORD_KEY_MAVEN = "cayenneJdbcPassword";
    private static final String URL_KEY_MAVEN = "cayenneJdbcUrl";
    private static final String DRIVER_KEY_MAVEN = "cayenneJdbcDriver";
    private Map<String, DataSourceInfo> inMemoryDataSources;
    private ConnectionProperties connectionProperties;
    private final Map<String, TestContainerProvider> testContainerProviders;

    public ServerCaseDataSourceInfoProvider(@Inject Map<String, TestContainerProvider> testContainerProviders) throws IOException {
        this.testContainerProviders = testContainerProviders;
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        File file = this.connectionPropertiesFile();
        if (file.exists()) {
            Properties properties = new Properties();
            properties.load(new FileReader(file));
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> propertiesMap.put(k.toString(), v.toString())));
        }
        this.connectionProperties = new ConnectionProperties(propertiesMap);
        logger.info("Loaded  " + this.connectionProperties.size() + " DataSource configurations from properties file");
        this.inMemoryDataSources = new HashMap<String, DataSourceInfo>();
        DataSourceInfo hsqldb = new DataSourceInfo();
        hsqldb.setAdapterClassName(HSQLDBAdapter.class.getName());
        hsqldb.setUserName("sa");
        hsqldb.setPassword("");
        hsqldb.setDataSourceUrl("jdbc:hsqldb:mem:aname;sql.regular_names=false");
        hsqldb.setJdbcDriver("org.hsqldb.jdbcDriver");
        hsqldb.setMinConnections(1);
        hsqldb.setMaxConnections(3);
        this.inMemoryDataSources.put("hsql", hsqldb);
        DataSourceInfo h2 = new DataSourceInfo();
        h2.setAdapterClassName(H2Adapter.class.getName());
        h2.setUserName("sa");
        h2.setPassword("");
        h2.setDataSourceUrl("jdbc:h2:mem:aname;DB_CLOSE_DELAY=-1");
        h2.setJdbcDriver("org.h2.Driver");
        h2.setMinConnections(1);
        h2.setMaxConnections(3);
        this.inMemoryDataSources.put("h2", h2);
        DataSourceInfo derby = new DataSourceInfo();
        derby.setAdapterClassName(DerbyAdapter.class.getName());
        derby.setUserName("sa");
        derby.setPassword("");
        derby.setDataSourceUrl("jdbc:derby:target/testdb;create=true");
        derby.setJdbcDriver("org.apache.derby.jdbc.EmbeddedDriver");
        derby.setMinConnections(1);
        derby.setMaxConnections(3);
        this.inMemoryDataSources.put("derby", derby);
        DataSourceInfo sqlite = new DataSourceInfo();
        sqlite.setAdapterClassName(SQLiteAdapter.class.getName());
        sqlite.setUserName("sa");
        sqlite.setPassword("");
        sqlite.setDataSourceUrl("jdbc:sqlite:file:memdb?mode=memory&cache=shared&date_class=text");
        sqlite.setJdbcDriver("org.sqlite.JDBC");
        sqlite.setMinConnections(1);
        sqlite.setMaxConnections(3);
        this.inMemoryDataSources.put("sqlite", sqlite);
    }

    public DataSourceInfo get() throws ConfigurationException {
        String connectionKey = this.property(CONNECTION_NAME_KEY);
        if (connectionKey == null) {
            connectionKey = "hsql";
        }
        logger.info("Connection key: " + connectionKey);
        DataSourceInfo connectionInfo = this.connectionProperties.getConnection(connectionKey);
        if (connectionInfo == null) {
            connectionInfo = this.inMemoryDataSources.get(connectionKey);
        }
        if (connectionInfo == null) {
            connectionInfo = this.checkTestContainersDataSource(connectionKey);
        }
        if ((connectionInfo = this.applyOverrides(connectionInfo)) == null) {
            throw new ConfigurationException("No connection info for key: " + connectionKey, new Object[0]);
        }
        logger.info("loaded connection info: " + connectionInfo);
        return connectionInfo;
    }

    private DataSourceInfo checkTestContainersDataSource(String connectionKey) {
        if (!connectionKey.endsWith("-tc")) {
            return null;
        }
        String db = connectionKey.substring(0, connectionKey.length() - 3);
        TestContainerProvider testContainerProvider = this.testContainerProviders.get(db);
        if (testContainerProvider == null) {
            return null;
        }
        String version = this.property(CONNECTION_DB_VERSION);
        JdbcDatabaseContainer<?> container = testContainerProvider.startContainer(version);
        DataSourceInfo sourceInfo = new DataSourceInfo();
        sourceInfo.setAdapterClassName(testContainerProvider.getAdapterClass().getName());
        sourceInfo.setUserName(container.getUsername());
        sourceInfo.setPassword(container.getPassword());
        sourceInfo.setDataSourceUrl(container.getJdbcUrl());
        sourceInfo.setJdbcDriver(container.getDriverClassName());
        sourceInfo.setMinConnections(1);
        sourceInfo.setMaxConnections(3);
        return sourceInfo;
    }

    private File connectionPropertiesFile() {
        return new File(this.cayenneUserDir(), PROPERTIES_FILE);
    }

    private File cayenneUserDir() {
        File homeDir = new File(System.getProperty("user.home"));
        return new File(homeDir, ".cayenne");
    }

    private DataSourceInfo applyOverrides(DataSourceInfo connectionInfo) {
        String adapter = this.property(ADAPTER_KEY_MAVEN);
        String user = this.property(USER_NAME_KEY_MAVEN);
        String pass = this.property(PASSWORD_KEY_MAVEN);
        String url = this.property(URL_KEY_MAVEN);
        String driver = this.property(DRIVER_KEY_MAVEN);
        if (connectionInfo == null) {
            if (url == null) {
                return null;
            }
            connectionInfo = new DataSourceInfo();
            connectionInfo.setMinConnections(1);
            connectionInfo.setMaxConnections(3);
        }
        connectionInfo = connectionInfo.cloneInfo();
        if (adapter != null) {
            connectionInfo.setAdapterClassName(adapter);
        }
        if (user != null) {
            connectionInfo.setUserName(user);
        }
        if (pass != null) {
            connectionInfo.setPassword(pass);
        }
        if (url != null) {
            connectionInfo.setDataSourceUrl(url);
        }
        if (driver != null) {
            connectionInfo.setJdbcDriver(driver);
        }
        return connectionInfo;
    }

    private String property(String name) {
        String p = System.getProperty(name);
        return p == null || p.startsWith("$") ? null : p;
    }
}

