/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.CayenneTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionIsolationIT;
import org.apache.cayenne.tx.TransactionListener;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionPropagation;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseServerRuntime(value="cayenne-testmap.xml")
public class TransactionCustomConnectionIT
extends ServerCase {
    private final Logger logger = LoggerFactory.getLogger(TransactionIsolationIT.class);
    @Inject
    DataContext context;
    @Inject
    ServerRuntime runtime;
    @Inject
    private JdbcEventLogger jdbcEventLogger;
    TransactionManager manager;
    private static boolean firstReadonlyCondition;

    @Before
    public void initTransactionManager() {
        this.manager = (TransactionManager)this.runtime.getInjector().getInstance(TransactionManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionDecorationWithListeners() {
        CayenneTransaction t = new CayenneTransaction(this.jdbcEventLogger);
        List<TransactionListener> listeners = this.addAndGetListenersWithCustomReadonlyTo(t);
        BaseTransaction.bindThreadTransaction(t);
        try {
            ObjectSelect.query(Artist.class).select(this.context);
            t.getConnections().forEach((key, connection) -> {
                try {
                    Assert.assertEquals((Object)connection.isReadOnly(), (Object)firstReadonlyCondition);
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            });
            for (TransactionListener transactionListener : listeners) {
                ((TransactionListener)Mockito.verify((Object)transactionListener)).decorateConnection((Transaction)ArgumentMatchers.any(), (Connection)ArgumentMatchers.any());
            }
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
            t.commit();
        }
    }

    private List<TransactionListener> addAndGetListenersWithCustomReadonlyTo(Transaction t) {
        Class[] classes = new Class[]{ListenerWithFirstReadonlyDecorator.class, ListenerWithSecondReadonlyDecorator.class};
        ArrayList<TransactionListener> listeners = new ArrayList<TransactionListener>();
        for (Class aClass : classes) {
            TransactionListener listener = (TransactionListener)Mockito.mock((Class)aClass);
            listeners.add(listener);
            Mockito.when((Object)listener.decorateConnection((Transaction)ArgumentMatchers.any(), (Connection)ArgumentMatchers.any())).thenCallRealMethod();
            t.addListener(listener);
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultConnectionInDescriptor() {
        CayenneTransaction t = new CayenneTransaction(this.jdbcEventLogger);
        BaseTransaction.bindThreadTransaction(t);
        try {
            ObjectSelect.query(Artist.class).select(this.context);
            Connection connection = t.getConnections().values().stream().findFirst().get();
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            TransactionDescriptor mockDescriptor = (TransactionDescriptor)Mockito.mock(TransactionDescriptor.class);
            Mockito.when(mockDescriptor.getConnectionSupplier()).thenReturn(() -> connection);
            Mockito.when((Object)((Object)mockDescriptor.getPropagation())).thenReturn((Object)TransactionPropagation.REQUIRES_NEW);
            Mockito.when((Object)mockDescriptor.getIsolation()).thenReturn((Object)8);
            this.performInTransaction(mockDescriptor);
            ((TransactionDescriptor)Mockito.verify((Object)mockDescriptor, (VerificationMode)Mockito.times((int)2))).getConnectionSupplier();
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
            t.commit();
        }
    }

    private void performInTransaction(TransactionDescriptor descriptor) {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("test");
        this.manager.performInTransaction(() -> {
            artist.setArtistName("test3");
            this.context.commitChanges();
            return null;
        }, descriptor);
    }

    class ListenerWithSecondReadonlyDecorator
    implements TransactionListener {
        ListenerWithSecondReadonlyDecorator() {
        }

        @Override
        public void willCommit(Transaction tx) {
        }

        @Override
        public void willRollback(Transaction tx) {
        }

        @Override
        public void willAddConnection(Transaction tx, String connectionName, Connection connection) {
        }

        @Override
        public Connection decorateConnection(Transaction tx, Connection connection) {
            try {
                Assert.assertEquals((Object)(!firstReadonlyCondition ? 1 : 0), (Object)connection.isReadOnly());
                connection.setReadOnly(!connection.isReadOnly());
                if (connection.isReadOnly() == !firstReadonlyCondition) {
                    firstReadonlyCondition = !firstReadonlyCondition;
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            return connection;
        }
    }

    class ListenerWithFirstReadonlyDecorator
    implements TransactionListener {
        ListenerWithFirstReadonlyDecorator() {
        }

        @Override
        public void willCommit(Transaction tx) {
        }

        @Override
        public void willRollback(Transaction tx) {
        }

        @Override
        public void willAddConnection(Transaction tx, String connectionName, Connection connection) {
        }

        @Override
        public Connection decorateConnection(Transaction tx, Connection connection) {
            try {
                firstReadonlyCondition = connection.isReadOnly();
                connection.setReadOnly(!firstReadonlyCondition);
                if (connection.isReadOnly() == firstReadonlyCondition) {
                    firstReadonlyCondition = !connection.isReadOnly();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            return connection;
        }
    }
}

