/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.SelectById;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SelectById_RunIT
extends ServerCase {
    @Inject
    private DataChannelInterceptor interceptor;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;
    @Inject
    private ObjectContext context;
    @Inject
    private EntityResolver resolver;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST").setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING").setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"}).setColumnTypes(new int[]{4, -5, 12});
    }

    private void createTwoArtists() throws Exception {
        this.tArtist.insert(new Object[]{2, "artist2"});
        this.tArtist.insert(new Object[]{3, "artist3"});
    }

    @Test
    public void testIntPk() throws Exception {
        this.createTwoArtists();
        Artist a3 = SelectById.query(Artist.class, 3).selectOne(this.context);
        Assert.assertNotNull((Object)a3);
        Assert.assertEquals((Object)"artist3", (Object)a3.getArtistName());
        Artist a2 = SelectById.query(Artist.class, 2).selectOne(this.context);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)"artist2", (Object)a2.getArtistName());
    }

    @Test
    public void testIntPkMulti() throws Exception {
        this.createTwoArtists();
        List<Artist> artists = SelectById.query(Artist.class, 2, 3).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertThat((Object)artists.get(0), (Matcher)CoreMatchers.instanceOf(Artist.class));
    }

    @Test
    public void testIntPkCollection() throws Exception {
        this.createTwoArtists();
        List<Artist> artists = SelectById.query(Artist.class, Arrays.asList(1, 2, 3, 4, 5)).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertThat((Object)artists.get(0), (Matcher)CoreMatchers.instanceOf(Artist.class));
    }

    @Test
    public void testIntPk_SelectFirst() throws Exception {
        this.createTwoArtists();
        Artist a3 = SelectById.query(Artist.class, 3).selectFirst(this.context);
        Assert.assertNotNull((Object)a3);
        Assert.assertEquals((Object)"artist3", (Object)a3.getArtistName());
        Artist a2 = SelectById.query(Artist.class, 2).selectFirst(this.context);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)"artist2", (Object)a2.getArtistName());
    }

    @Test
    public void testMapPk() throws Exception {
        this.createTwoArtists();
        Artist a3 = SelectById.query(Artist.class, Collections.singletonMap("ARTIST_ID", 3)).selectOne(this.context);
        Assert.assertNotNull((Object)a3);
        Assert.assertEquals((Object)"artist3", (Object)a3.getArtistName());
        Artist a2 = SelectById.query(Artist.class, Collections.singletonMap("ARTIST_ID", 2)).selectOne(this.context);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)"artist2", (Object)a2.getArtistName());
    }

    @Test
    public void testMapPkMulti() throws Exception {
        this.createTwoArtists();
        Map<String, Integer> id2 = Collections.singletonMap("ARTIST_ID", 2);
        Map<String, Integer> id3 = Collections.singletonMap("ARTIST_ID", 3);
        List<Artist> artists = SelectById.query(Artist.class, id2, id3).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertThat((Object)artists.get(0), (Matcher)CoreMatchers.instanceOf(Artist.class));
    }

    @Test
    public void testObjectIdPk() throws Exception {
        this.createTwoArtists();
        ObjectId oid3 = ObjectId.of("Artist", "ARTIST_ID", 3);
        Artist a3 = SelectById.query(Artist.class, oid3).selectOne(this.context);
        Assert.assertNotNull((Object)a3);
        Assert.assertEquals((Object)"artist3", (Object)a3.getArtistName());
        ObjectId oid2 = ObjectId.of("Artist", "ARTIST_ID", 2);
        Artist a2 = SelectById.query(Artist.class, oid2).selectOne(this.context);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)"artist2", (Object)a2.getArtistName());
    }

    @Test
    public void testObjectIdPkMulti() throws Exception {
        this.createTwoArtists();
        ObjectId oid2 = ObjectId.of("Artist", "ARTIST_ID", 2);
        ObjectId oid3 = ObjectId.of("Artist", "ARTIST_ID", 3);
        List<Artist> artists = SelectById.query(Artist.class, oid2, oid3).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertThat((Object)artists.get(0), (Matcher)CoreMatchers.instanceOf(Artist.class));
    }

    @Test
    public void testDataRowIntPk() throws Exception {
        this.createTwoArtists();
        DataRow a3 = SelectById.dataRowQuery(Artist.class, 3).selectOne(this.context);
        Assert.assertNotNull((Object)a3);
        Assert.assertEquals((Object)"artist3", a3.get("ARTIST_NAME"));
        DataRow a2 = SelectById.dataRowQuery(Artist.class, 2).selectOne(this.context);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)"artist2", a2.get("ARTIST_NAME"));
    }

    @Test
    public void testDataRowMapPk() throws Exception {
        this.createTwoArtists();
        Map<String, Integer> id3 = Collections.singletonMap("ARTIST_ID", 3);
        DataRow a3 = SelectById.dataRowQuery(Artist.class, id3).selectOne(this.context);
        Assert.assertNotNull((Object)a3);
        Assert.assertEquals((Object)"artist3", a3.get("ARTIST_NAME"));
        Map<String, Integer> id2 = Collections.singletonMap("ARTIST_ID", 2);
        DataRow a2 = SelectById.dataRowQuery(Artist.class, id2).selectOne(this.context);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)"artist2", a2.get("ARTIST_NAME"));
    }

    @Test
    public void testDataRowObjectIdPk() throws Exception {
        this.createTwoArtists();
        ObjectId oid3 = ObjectId.of("Artist", "ARTIST_ID", 3);
        DataRow a3 = SelectById.dataRowQuery(oid3).selectOne(this.context);
        Assert.assertNotNull((Object)a3);
        Assert.assertEquals((Object)"artist3", a3.get("ARTIST_NAME"));
        ObjectId oid2 = ObjectId.of("Artist", "ARTIST_ID", 2);
        DataRow a2 = SelectById.dataRowQuery(oid2).selectOne(this.context);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)"artist2", a2.get("ARTIST_NAME"));
    }

    @Test
    public void testDataRowIntPkMulti() throws Exception {
        this.createTwoArtists();
        List<DataRow> artists = SelectById.dataRowQuery(Artist.class, 2, 3).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertThat((Object)artists.get(0), (Matcher)CoreMatchers.instanceOf(DataRow.class));
    }

    @Test
    public void testDataRowMapPkMulti() throws Exception {
        this.createTwoArtists();
        ObjectId oid2 = ObjectId.of("Artist", "ARTIST_ID", 2);
        ObjectId oid3 = ObjectId.of("Artist", "ARTIST_ID", 3);
        List<DataRow> artists = SelectById.dataRowQuery(oid2, oid3).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertThat((Object)artists.get(0), (Matcher)CoreMatchers.instanceOf(DataRow.class));
    }

    @Test
    public void testDataRowObjectIdPkMulti() throws Exception {
        this.createTwoArtists();
        Map<String, Integer> id2 = Collections.singletonMap("ARTIST_ID", 2);
        Map<String, Integer> id3 = Collections.singletonMap("ARTIST_ID", 3);
        List<DataRow> artists = SelectById.dataRowQuery(Artist.class, id2, id3).select(this.context);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertThat((Object)artists.get(0), (Matcher)CoreMatchers.instanceOf(DataRow.class));
    }

    @Test
    public void testMetadataCacheKey() throws Exception {
        SelectById<Painting> q1 = SelectById.query(Painting.class, 4).localCache();
        QueryMetadata md1 = q1.getMetaData(this.resolver);
        Assert.assertNotNull((Object)md1);
        Assert.assertNotNull((Object)md1.getCacheKey());
        SelectById<Painting> q2 = SelectById.query(Painting.class, Collections.singletonMap("PAINTING_ID", 4)).localCache();
        QueryMetadata md2 = q2.getMetaData(this.resolver);
        Assert.assertNotNull((Object)md2);
        Assert.assertNotNull((Object)md2.getCacheKey());
        Assert.assertEquals((Object)md1.getCacheKey(), (Object)md2.getCacheKey());
        SelectById<Painting> q3 = SelectById.query(Painting.class, 5).localCache();
        QueryMetadata md3 = q3.getMetaData(this.resolver);
        Assert.assertNotNull((Object)md3);
        Assert.assertNotNull((Object)md3.getCacheKey());
        Assert.assertNotEquals((Object)md1.getCacheKey(), (Object)md3.getCacheKey());
        SelectById<Artist> q4 = SelectById.query(Artist.class, 4).localCache();
        QueryMetadata md4 = q4.getMetaData(this.resolver);
        Assert.assertNotNull((Object)md4);
        Assert.assertNotNull((Object)md4.getCacheKey());
        Assert.assertNotEquals((Object)md1.getCacheKey(), (Object)md4.getCacheKey());
        SelectById<Painting> q5 = SelectById.query(Painting.class, ObjectId.of("Painting", "PAINTING_ID", 4)).localCache();
        QueryMetadata md5 = q5.getMetaData(this.resolver);
        Assert.assertNotNull((Object)md5);
        Assert.assertNotNull((Object)md5.getCacheKey());
        Assert.assertEquals((Object)md1.getCacheKey(), (Object)md5.getCacheKey());
    }

    @Test
    public void testLocalCache() throws Exception {
        this.createTwoArtists();
        Artist[] a3 = new Artist[1];
        Assert.assertEquals((long)1L, (long)this.interceptor.runWithQueryCounter(() -> {
            a3[0] = SelectById.query(Artist.class, 3).localCache("g1").selectOne(this.context);
            Assert.assertNotNull((Object)a3[0]);
            Assert.assertEquals((Object)"artist3", (Object)a3[0].getArtistName());
        }));
        this.interceptor.runWithQueriesBlocked(() -> {
            Artist a3cached = SelectById.query(Artist.class, 3).localCache("g1").selectOne(this.context);
            Assert.assertSame((Object)a3[0], (Object)a3cached);
        });
        this.context.performGenericQuery(new RefreshQuery("g1"));
        Assert.assertEquals((long)1L, (long)this.interceptor.runWithQueryCounter(() -> SelectById.query(Artist.class, 3).localCache("g1").selectOne(this.context)));
    }

    @Test
    public void testPrefetch() throws Exception {
        this.createTwoArtists();
        this.tPainting.insert(new Object[]{45, 3, "One"});
        this.tPainting.insert(new Object[]{48, 3, "Two"});
        Artist a3 = SelectById.query(Artist.class, 3).prefetch(Artist.PAINTING_ARRAY.joint()).selectOne(this.context);
        this.interceptor.runWithQueriesBlocked(() -> {
            Assert.assertNotNull((Object)a3);
            Assert.assertEquals((Object)"artist3", (Object)a3.getArtistName());
            Assert.assertEquals((long)2L, (long)a3.getPaintingArray().size());
            a3.getPaintingArray().get(0).getPaintingTitle();
            a3.getPaintingArray().get(1).getPaintingTitle();
        });
    }
}

