/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.List;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;

public class DbAttributeTest {
    @Test
    public void testConstructor1() throws Exception {
        DbAttribute a = new DbAttribute("abc");
        Assert.assertEquals((Object)"abc", (Object)a.getName());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)a.getType());
        Assert.assertNull((Object)a.getEntity());
    }

    @Test
    public void testConstructor2() throws Exception {
        int type = 4;
        DbEntity dbe = new DbEntity("e");
        DbAttribute a = new DbAttribute("abc", type, dbe);
        Assert.assertEquals((Object)"abc", (Object)a.getName());
        Assert.assertEquals((long)type, (long)a.getType());
        Assert.assertSame((Object)dbe, (Object)a.getEntity());
    }

    @Test
    public void testPrimaryKeyEmpty() {
        DbEntity dbe = new DbEntity("e");
        Assert.assertNotNull(dbe.getPrimaryKeys());
        DbAttribute a = new DbAttribute("abc", 4, dbe);
        dbe.addAttribute(a);
        Assert.assertNotNull(dbe.getPrimaryKeys());
        Assert.assertEquals((long)0L, (long)dbe.getPrimaryKeys().size());
    }

    @Test
    public void testPrimaryKeyAdded() {
        DbEntity dbe = new DbEntity("e");
        DbAttribute a = new DbAttribute("abc", 4, dbe);
        a.setPrimaryKey(true);
        dbe.addAttribute(a);
        List<DbAttribute> pk = dbe.getPrimaryKeys();
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)1L, (long)pk.size());
    }

    @Test
    public void testPrimaryKeyAttributeChanged() {
        DbEntity dbe = new DbEntity("e");
        DbAttribute a = new DbAttribute("abc", 4, dbe);
        dbe.addAttribute(a);
        List<DbAttribute> pk = dbe.getPrimaryKeys();
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)0L, (long)pk.size());
        a.setPrimaryKey(true);
        pk = dbe.getPrimaryKeys();
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)1L, (long)pk.size());
    }

    @Test
    public void testPrimaryKeyRemoved() {
        DbEntity dbe = new DbEntity("e");
        DbAttribute a = new DbAttribute("abc", 4, dbe);
        a.setPrimaryKey(true);
        dbe.addAttribute(a);
        List<DbAttribute> pk = dbe.getPrimaryKeys();
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)1L, (long)pk.size());
        dbe.removeAttribute(a.getName());
        pk = dbe.getPrimaryKeys();
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)0L, (long)pk.size());
    }

    @Test
    public void testAttributesCleared() {
        DbEntity dbe = new DbEntity("e");
        DbAttribute a = new DbAttribute("abc", 4, dbe);
        a.setPrimaryKey(true);
        dbe.addAttribute(a);
        List<DbAttribute> pk = dbe.getPrimaryKeys();
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)1L, (long)pk.size());
        dbe.clearAttributes();
        pk = dbe.getPrimaryKeys();
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)0L, (long)pk.size());
    }

    @Test
    public void testAutoIncrement() throws Exception {
        DbAttribute attribute = new DbAttribute();
        Assert.assertFalse((boolean)attribute.isGenerated());
        attribute.setGenerated(true);
        Assert.assertTrue((boolean)attribute.isGenerated());
        attribute.setGenerated(false);
        Assert.assertFalse((boolean)attribute.isGenerated());
    }
}

