/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.HashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.junit.Assert;
import org.junit.Test;

public class IdPropertyTest {
    @Test
    public void expressionContentAttribute() {
        Assert.assertEquals((Object)ExpressionFactory.dbIdPathExp("ARTIST_ID"), (Object)PropertyFactory.createNumericId("ARTIST_ID", "Artist", Long.class).getExpression());
    }

    @Test
    public void expressionContentPathAttribute() {
        Assert.assertEquals((Object)ExpressionFactory.dbIdPathExp("path.ARTIST_ID"), (Object)PropertyFactory.createNumericId("ARTIST_ID", "path", "Artist", Long.class).getExpression());
    }

    @Test
    public void eqObjectIdAttribute() {
        ObjectId id = ObjectId.of("Artist", "ARTIST_ID", 2);
        Assert.assertEquals((Object)ExpressionFactory.matchDbIdExp("ARTIST_ID", 2), (Object)PropertyFactory.createNumericId("ARTIST_ID", "Artist", Integer.class).eq((Integer)((Object)id)));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void eqObjectIdWrongAttribute() {
        ObjectId id = ObjectId.of("Artist", "ARTIST_ID", 2);
        PropertyFactory.createNumericId("ARTIST_PK", "Artist", Integer.class).eq((Integer)((Object)id));
    }

    @Test
    public void eqObjectIdCompound() {
        HashMap<String, Integer> key = new HashMap<String, Integer>();
        key.put("ARTIST_ID", 2);
        key.put("SERIAL", 1);
        ObjectId id = ObjectId.of("Artist", key);
        Assert.assertEquals((Object)ExpressionFactory.matchDbIdExp("ARTIST_ID", 2), (Object)PropertyFactory.createNumericId("ARTIST_ID", "Artist", Integer.class).eq((Integer)((Object)id)));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void eqObjectIdWrongCompound() {
        HashMap<String, Integer> key = new HashMap<String, Integer>();
        key.put("ARTIST_ID", 2);
        key.put("SERIAL", 1);
        ObjectId id = ObjectId.of("Artist", key);
        PropertyFactory.createNumericId("Artist", "ARTIST_ID", Integer.class).eq((Integer)((Object)id));
    }
}

