/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ExpressionUtils;
import org.apache.cayenne.exp.parser.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionUtilsTest {
    @Test
    public void testParsePath() throws ParseException {
        ASTObjPath path = new ASTObjPath();
        ExpressionUtils.parsePath(path, "a.b.c.d");
        Assert.assertEquals((Object)"a.b.c.d", (Object)path.getPath());
        Assert.assertEquals((long)0L, (long)path.getPathAliases().size());
    }

    @Test
    public void testParsePathOuterJoin() throws ParseException {
        ASTObjPath path = new ASTObjPath();
        ExpressionUtils.parsePath(path, "a.b+.c+.d");
        Assert.assertEquals((Object)"a.b+.c+.d", (Object)path.getPath());
        Assert.assertEquals((long)0L, (long)path.getPathAliases().size());
    }

    @Test
    public void testParsePathWithAlias() throws ParseException {
        ASTObjPath path = new ASTObjPath();
        ExpressionUtils.parsePath(path, "a.b.c#p1.d#p2");
        Assert.assertEquals((Object)"a.b.p1.p2", (Object)path.getPath());
        Assert.assertEquals((long)2L, (long)path.getPathAliases().size());
        Assert.assertEquals((Object)"c", (Object)path.getPathAliases().get("p1"));
        Assert.assertEquals((Object)"d", (Object)path.getPathAliases().get("p2"));
    }

    @Test
    public void testParsePathWithAliasAndOuterJoin() throws ParseException {
        ASTObjPath path = new ASTObjPath();
        ExpressionUtils.parsePath(path, "a.b+.c#p1+.d#p2");
        Assert.assertEquals((Object)"a.b+.p1.p2", (Object)path.getPath());
        Assert.assertEquals((long)2L, (long)path.getPathAliases().size());
        Assert.assertEquals((Object)"c+", (Object)path.getPathAliases().get("p1"));
        Assert.assertEquals((Object)"d", (Object)path.getPathAliases().get("p2"));
    }

    @Test(expected=ParseException.class)
    public void testParseInvalidPath() throws ParseException {
        ASTObjPath path = new ASTObjPath();
        ExpressionUtils.parsePath(path, "a.b.c#p1.d#p1");
    }
}

