/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTAdd;
import org.apache.cayenne.exp.parser.ASTAnd;
import org.apache.cayenne.exp.parser.ASTDivide;
import org.apache.cayenne.exp.parser.ASTFalse;
import org.apache.cayenne.exp.parser.ASTGreater;
import org.apache.cayenne.exp.parser.ASTMultiply;
import org.apache.cayenne.exp.parser.ASTNegate;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTOr;
import org.apache.cayenne.exp.parser.ASTSubtract;
import org.apache.cayenne.exp.parser.ASTTrue;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionEvaluateInMemoryTest {
    @Test
    public void testEvaluateADD() {
        ASTAdd add = new ASTAdd(1, 5.5);
        Assert.assertEquals((double)6.5, (double)((Number)((Expression)add).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateSubtract() {
        ASTSubtract subtract = new ASTSubtract(1, 0.1, 0.2);
        Assert.assertEquals((double)0.7, (double)((Number)((Expression)subtract).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateMultiply() {
        ASTMultiply multiply = new ASTMultiply(2, 3.5);
        Assert.assertEquals((double)7.0, (double)((Number)((Expression)multiply).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateDivide() {
        ASTDivide divide = new ASTDivide(new BigDecimal("7.0"), new BigDecimal("2.0"));
        Assert.assertEquals((double)3.5, (double)((Number)((Expression)divide).evaluate(null)).doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testEvaluateNegate() {
        Assert.assertEquals((long)-3L, (long)((Number)new ASTNegate((Object)3).evaluate(null)).intValue());
        Assert.assertEquals((long)5L, (long)((Number)new ASTNegate((Object)-5).evaluate(null)).intValue());
    }

    @Test
    public void testEvaluateTrue() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)new ASTTrue().evaluate(null));
    }

    @Test
    public void testEvaluateFalse() {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)new ASTFalse().evaluate(null));
    }

    @Test
    public void testEvaluateNullCompare() throws Exception {
        ASTGreater expression = new ASTGreater(new ASTObjPath("artistName"), "A");
        TestCase.assertFalse((boolean)expression.match(new Artist()));
        TestCase.assertFalse((boolean)((Expression)expression).notExp().match(new Artist()));
    }

    @Test
    public void testEvaluateCompareNull() throws Exception {
        Artist a1 = new Artist();
        a1.setArtistName("Name");
        Expression expression = new ASTGreater(new ASTObjPath("artistName"), null);
        TestCase.assertFalse((boolean)expression.match(a1));
        TestCase.assertFalse((boolean)expression.notExp().match(a1));
        a1.setSomeOtherObjectProperty(new BigDecimal(1));
        expression = ExpressionFactory.exp("someOtherObjectProperty > null", new Object[0]);
        TestCase.assertFalse((boolean)expression.match(a1));
    }

    @Test
    public void testEvaluateEqualsNull() throws Exception {
        Artist a1 = new Artist();
        Expression isNull = Artist.ARTIST_NAME.isNull();
        TestCase.assertTrue((boolean)isNull.match(a1));
        TestCase.assertFalse((boolean)isNull.notExp().match(a1));
    }

    @Test
    public void testEvaluateNotEqualsNullColumn() throws Exception {
        Expression notEquals = ExpressionFactory.exp("artistName <> someOtherProperty", new Object[0]);
        TestCase.assertFalse((boolean)notEquals.match(new Artist()));
        TestCase.assertTrue((boolean)notEquals.notExp().match(new Artist()));
    }

    @Test
    public void testNullAnd() {
        Expression nullExp = ExpressionFactory.exp("null > 0", new Object[0]);
        ASTAnd nullAndTrue = new ASTAnd(new Object[]{nullExp, new ASTTrue()});
        TestCase.assertFalse((boolean)nullAndTrue.match(null));
        TestCase.assertFalse((boolean)nullAndTrue.notExp().match(null));
        ASTAnd nullAndFalse = new ASTAnd(new Object[]{nullExp, new ASTFalse()});
        TestCase.assertFalse((boolean)nullAndFalse.match(null));
        TestCase.assertTrue((boolean)nullAndFalse.notExp().match(null));
    }

    @Test
    public void testNullOr() {
        Expression nullExp = ExpressionFactory.exp("null > 0", new Object[0]);
        ASTOr nullOrTrue = new ASTOr(new Object[]{nullExp, new ASTTrue()});
        TestCase.assertTrue((boolean)nullOrTrue.match(null));
        TestCase.assertFalse((boolean)nullOrTrue.notExp().match(null));
        ASTOr nullOrFalse = new ASTOr(new Object[]{nullExp, new ASTFalse()});
        TestCase.assertFalse((boolean)nullOrFalse.match(null));
        TestCase.assertFalse((boolean)nullOrFalse.notExp().match(null));
    }
}

