/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.LimitOffsetStage;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.map.DbEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LimitOffsetStageTest {
    private TranslatorContext context;

    @Before
    public void prepareContext() {
        DbEntity entity = new DbEntity();
        entity.setName("mock");
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withMetaData(new MockQueryMetadataBuilder().withDbEntity(entity).withLimitOffset(123, 321).build()).build();
        this.context = new MockTranslatorContext(wrapper);
    }

    @Test
    public void perform() {
        LimitOffsetStage stage = new LimitOffsetStage();
        stage.perform(this.context);
        Node select = this.context.getSelectBuilder().build();
        Node child = select.getChild(0);
        Assert.assertThat((Object)child, (Matcher)CoreMatchers.instanceOf(LimitOffsetNode.class));
        LimitOffsetNode limitOffsetNode = (LimitOffsetNode)child;
        Assert.assertEquals((long)123L, (long)limitOffsetNode.getLimit());
        Assert.assertEquals((long)321L, (long)limitOffsetNode.getOffset());
    }
}

