/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.flush.ArcValuesCreationHandler;
import org.apache.cayenne.access.flush.DbRowOpFactory;
import org.apache.cayenne.access.flush.OptimisticLockQualifierBuilder;
import org.apache.cayenne.access.flush.ValuesCreationHandler;
import org.apache.cayenne.access.flush.operation.DbRowOpType;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.graph.GraphChangeHandler;

class RootRowOpProcessor
implements DbRowOpVisitor<Void> {
    private final DbRowOpFactory dbRowOpFactory;
    private final GraphChangeHandler insertHandler;
    private final GraphChangeHandler updateHandler;
    private final GraphChangeHandler deleteHandler;
    private ObjectDiff diff;

    RootRowOpProcessor(DbRowOpFactory dbRowOpFactory) {
        this.dbRowOpFactory = dbRowOpFactory;
        this.insertHandler = new ValuesCreationHandler(dbRowOpFactory, DbRowOpType.INSERT);
        this.updateHandler = new ValuesCreationHandler(dbRowOpFactory, DbRowOpType.UPDATE);
        this.deleteHandler = new ArcValuesCreationHandler(dbRowOpFactory, DbRowOpType.DELETE);
    }

    void setDiff(ObjectDiff diff) {
        this.diff = diff;
    }

    @Override
    public Void visitInsert(InsertDbRowOp dbRow) {
        this.diff.apply(this.insertHandler);
        return null;
    }

    @Override
    public Void visitUpdate(UpdateDbRowOp dbRow) {
        this.diff.apply(this.updateHandler);
        if (this.dbRowOpFactory.getDescriptor().getEntity().getDeclaredLockType() == 1) {
            this.dbRowOpFactory.getDescriptor().visitAllProperties(new OptimisticLockQualifierBuilder(dbRow, this.diff));
        }
        return null;
    }

    @Override
    public Void visitDelete(DeleteDbRowOp dbRow) {
        if (this.dbRowOpFactory.getDescriptor().getEntity().isReadOnly()) {
            throw new CayenneRuntimeException("Attempt to modify object(s) mapped to a read-only entity: '%s'. Can't commit changes.", this.dbRowOpFactory.getDescriptor().getEntity().getName());
        }
        this.diff.apply(this.deleteHandler);
        Collection<ObjectId> flattenedIds = this.dbRowOpFactory.getStore().getFlattenedIds(dbRow.getChangeId());
        flattenedIds.forEach(id -> this.dbRowOpFactory.getOrCreate(this.dbRowOpFactory.getDbEntity((ObjectId)id), (ObjectId)id, DbRowOpType.DELETE));
        if (this.dbRowOpFactory.getDescriptor().getEntity().getDeclaredLockType() == 1) {
            this.dbRowOpFactory.getDescriptor().visitAllProperties(new OptimisticLockQualifierBuilder(dbRow, this.diff));
        }
        return null;
    }
}

