/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTEqual;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.cay_2666.CAY2666;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cay2666/cayenne-cay-2666.xml")
public class Cay2666IT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tTest;

    @Test
    public void testExp_Path() {
        Expression exp1 = ExpressionFactory.exp("object$.path", new Object[0]);
        Assert.assertEquals((long)26L, (long)exp1.getType());
        Expression exp2 = ExpressionFactory.exp("db:object.path$", new Object[0]);
        Assert.assertEquals((long)27L, (long)exp2.getType());
    }

    @Test
    public void testPathExp() {
        Assert.assertEquals((Object)"abc$.xyz$", (Object)ExpressionFactory.pathExp("abc$.xyz$").toString());
    }

    @Test
    public void testDbPathExp() {
        Assert.assertEquals((Object)"db:abc.xyz$", (Object)ExpressionFactory.dbPathExp("abc.xyz$").toString());
    }

    @Test
    public void testExpWithAlias() {
        Expression expression = ExpressionFactory.exp("paintings#p1.galleries$#p2.name = 'Test'", new Object[0]);
        Assert.assertEquals((Object)"p1.p2.name", (Object)expression.getOperand(0).toString());
        Assert.assertEquals((Object)"galleries$", (Object)((ASTObjPath)expression.getOperand(0)).getPathAliases().get("p2"));
    }

    @Test
    public void testExpWithAliasAndOuterJoin() {
        Expression expression = ExpressionFactory.exp("paintings$#p1+.name = 'Test'", new Object[0]);
        Assert.assertEquals((Object)"p1.name", (Object)expression.getOperand(0).toString());
        Assert.assertEquals((Object)"paintings$+", (Object)((ASTObjPath)expression.getOperand(0)).getPathAliases().get("p1"));
    }

    @Test
    public void testDbPathWithDollarSign() throws IOException {
        StringBuilder buffer = new StringBuilder();
        new ASTDbPath("x$").appendAsString(buffer);
        Assert.assertEquals((Object)"db:x$", (Object)buffer.toString());
    }

    @Test
    public void testExpDbPathWithDollarSign() throws IOException {
        Expression exp = ExpressionFactory.exp("db:x$ = 'A'", new Object[0]);
        ASTEqual expression = new ASTEqual(new ASTDbPath("x$"), "A");
        Assert.assertEquals((Object)exp, (Object)expression);
        exp = ExpressionFactory.exp("x$ = 'A'", new Object[0]);
        expression = new ASTEqual(new ASTDbPath("x$"), "A");
        Assert.assertNotEquals((Object)exp, (Object)expression);
        exp = ExpressionFactory.exp("db:x$ = $name", "A");
        expression = new ASTEqual(new ASTDbPath("x$"), "A");
        Assert.assertEquals((Object)exp, (Object)expression);
    }

    @Test
    public void testObjPathWithDollarSign() throws IOException {
        StringBuilder buffer = new StringBuilder();
        new ASTObjPath("obj:x$").appendAsString(buffer);
        Assert.assertEquals((Object)"obj:x$", (Object)buffer.toString());
        Assert.assertEquals((Object)"y$", (Object)new ASTObjPath("y$").toString());
    }

    @Test
    public void testExpObjPathWithDollarSign() throws IOException {
        Expression exp = ExpressionFactory.exp("obj:x$ = 'A'", new Object[0]);
        ASTEqual expression = new ASTEqual(new ASTObjPath("x$"), "A");
        Assert.assertEquals((Object)exp, (Object)expression);
        exp = ExpressionFactory.exp("x$ = 'A'", new Object[0]);
        expression = new ASTEqual(new ASTObjPath("x$"), "A");
        Assert.assertEquals((Object)exp, (Object)expression);
        exp = ExpressionFactory.exp("obj:x$ = $name", "A");
        expression = new ASTEqual(new ASTObjPath("x$"), "A");
        Assert.assertEquals((Object)exp, (Object)expression);
    }

    @Test
    public void testExpressionWithDollarSign() throws Exception {
        this.tTest = new TableHelper(this.dbHelper, "Cay2666");
        this.tTest.setColumns(new String[]{"ID", "NAME$"});
        this.tTest.insert(new Object[]{1, "st.One"});
        Expression expression = ExpressionFactory.exp("name$ = 'st.One'", new Object[0]);
        List cay2666List = ObjectSelect.query(CAY2666.class).where(expression).select(this.context);
        Assert.assertEquals((long)1L, (long)cay2666List.size());
        expression = ExpressionFactory.exp("obj:name$ = 'st.Two'", new Object[0]);
        cay2666List = ObjectSelect.query(CAY2666.class).where(expression).select(this.context);
        Assert.assertEquals((long)0L, (long)cay2666List.size());
        this.tTest.insert(new Object[]{2, "st.Two"});
        expression = ExpressionFactory.exp("db:NAME$ = 'st.Two'", new Object[0]);
        cay2666List = ObjectSelect.query(CAY2666.class).where(expression).select(this.context);
        Assert.assertEquals((long)1L, (long)cay2666List.size());
    }
}

