/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.util.Optional;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LikeNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.translator.select.TypeAwareSQLTreeProcessor;
import org.apache.cayenne.dba.mysql.sqltree.MysqlLikeNode;
import org.apache.cayenne.dba.mysql.sqltree.MysqlLimitOffsetNode;
import org.apache.cayenne.value.GeoJson;
import org.apache.cayenne.value.Wkt;

public class MySQLTreeProcessor
extends TypeAwareSQLTreeProcessor {
    private static final MySQLTreeProcessor INSTANCE = new MySQLTreeProcessor();

    public static MySQLTreeProcessor getInstance() {
        return INSTANCE;
    }

    protected MySQLTreeProcessor() {
        this.registerProcessor(NodeType.LIKE, this::onLikeNode);
        this.registerProcessor(NodeType.LIMIT_OFFSET, this::onLimitOffsetNode);
        this.registerProcessor(NodeType.FUNCTION, this::onFunctionNode);
        this.registerColumnProcessor(Wkt.class, (parent, child, i) -> Optional.of(MySQLTreeProcessor.wrapInFunction(child, "ST_AsText")));
        this.registerColumnProcessor(GeoJson.class, (parent, child, i) -> Optional.of(MySQLTreeProcessor.wrapInFunction(child, "ST_AsGeoJSON")));
        this.registerValueProcessor(Wkt.class, (parent, child, i) -> Optional.of(MySQLTreeProcessor.wrapInFunction(child, "ST_GeomFromText")));
        this.registerValueProcessor(GeoJson.class, (parent, child, i) -> Optional.of(MySQLTreeProcessor.wrapInFunction(child, "ST_GeomFromGeoJSON")));
    }

    protected Optional<Node> onLikeNode(Node parent, LikeNode child, int index) {
        if (!child.isIgnoreCase()) {
            return Optional.of(new MysqlLikeNode(child.isNot(), child.getEscape()));
        }
        return Optional.empty();
    }

    protected Optional<Node> onLimitOffsetNode(Node parent, LimitOffsetNode child, int index) {
        return Optional.of(new MysqlLimitOffsetNode(child.getLimit(), child.getOffset()));
    }

    protected Optional<Node> onFunctionNode(Node parent, FunctionNode child, int index) {
        String functionName = child.getFunctionName();
        if ("DAY_OF_MONTH".equals(functionName) || "DAY_OF_WEEK".equals(functionName) || "DAY_OF_YEAR".equals(functionName)) {
            return Optional.of(new FunctionNode(functionName.replace("_", ""), child.getAlias(), true));
        }
        return Optional.empty();
    }
}

