/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import java.net.URL;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.xml.XMLDataChannelDescriptorLoader;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.FlavoredDBHelper;
import org.apache.cayenne.unit.di.server.SchemaBuilder;

public class DBCleaner {
    private FlavoredDBHelper dbHelper;
    private String location;
    @Inject
    private SchemaBuilder schemaBuilder;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    private Injector injector;

    public DBCleaner(FlavoredDBHelper dbHelper, String location) {
        this.dbHelper = dbHelper;
        this.location = location;
    }

    public void clean() throws SQLException {
        XMLDataChannelDescriptorLoader loader = new XMLDataChannelDescriptorLoader();
        this.injector.injectMembers((Object)loader);
        URL url = this.getClass().getClassLoader().getResource(this.location);
        ConfigurationTree<DataChannelDescriptor> tree = loader.load(new URLResource(url));
        for (DataMap map : tree.getRootNode().getDataMaps()) {
            List<DbEntity> entities = this.schemaBuilder.dbEntitiesInDeleteOrder(map);
            for (DbEntity entity : entities) {
                this.dbHelper.deleteAll(entity.getName());
            }
        }
    }
}

