/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.ComparableProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelectMetadata;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SortOrder;

public class ObjectSelect<T>
extends FluentSelect<T>
implements ParameterizedQuery {
    private static final long serialVersionUID = -156124021150949227L;
    protected ObjectSelectMetadata metaData = new ObjectSelectMetadata();

    public static <T> ObjectSelect<T> query(Class<T> entityType) {
        return new ObjectSelect<T>().entityType(entityType);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression) {
        return new ObjectSelect<T>().entityType(entityType).where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression, List<Ordering> orderings) {
        return new ObjectSelect<T>().entityType(entityType).where(expression).orderBy(orderings);
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType) {
        return ObjectSelect.query(entityType).fetchDataRows();
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType, Expression expression) {
        return ObjectSelect.query(entityType).fetchDataRows().where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> resultType, String entityName) {
        return new ObjectSelect<T>().entityName(entityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName) {
        return new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName, Expression expression) {
        return new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName).where(expression);
    }

    public static <E> ColumnSelect<E> columnQuery(Class<?> entityType, Property<E> column) {
        return new ColumnSelect().entityType(entityType).column(column);
    }

    public static ColumnSelect<Object[]> columnQuery(Class<?> entityType, Property<?> ... columns) {
        return new ColumnSelect().entityType(entityType).columns(columns);
    }

    protected ObjectSelect() {
    }

    public ObjectSelect<T> entityType(Class<?> entityType) {
        return this.resetEntity(entityType, null, null);
    }

    public ObjectSelect<T> entityName(String entityName) {
        return this.resetEntity(null, entityName, null);
    }

    public ObjectSelect<T> dbEntityName(String dbEntityName) {
        return this.resetEntity(null, null, dbEntityName);
    }

    private ObjectSelect<T> resetEntity(Class<?> entityType, String entityName, String dbEntityName) {
        this.entityType = entityType;
        this.entityName = entityName;
        this.dbEntityName = dbEntityName;
        return this;
    }

    public ObjectSelect<T> where(Expression expression) {
        return this.and(expression);
    }

    public ObjectSelect<T> where(String expressionString, Object ... parameters) {
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ObjectSelect<T> having(Expression expression) {
        this.havingExpressionIsActive = true;
        return this.and(expression);
    }

    public ObjectSelect<T> having(String expressionString, Object ... parameters) {
        this.havingExpressionIsActive = true;
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ObjectSelect<T> and(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.and(Arrays.asList(expressions));
    }

    public ObjectSelect<T> and(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(ExpressionFactory.and(all));
        return this;
    }

    public ObjectSelect<T> or(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.or(Arrays.asList(expressions));
    }

    public ObjectSelect<T> or(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(ExpressionFactory.or(all));
        return this;
    }

    public ObjectSelect<T> orderBy(String property) {
        return this.orderBy(new Ordering(property));
    }

    public ObjectSelect<T> orderBy(String property, SortOrder sortOrder) {
        return this.orderBy(new Ordering(property, sortOrder));
    }

    public ObjectSelect<T> orderBy(Ordering ... orderings) {
        if (orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList(orderings.length);
        }
        Collections.addAll(this.orderings, orderings);
        return this;
    }

    public ObjectSelect<T> orderBy(Collection<Ordering> orderings) {
        if (orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList(orderings.size());
        }
        this.orderings.addAll(orderings);
        return this;
    }

    public ObjectSelect<T> prefetch(PrefetchTreeNode prefetch) {
        this.metaData.mergePrefetch(prefetch);
        return this;
    }

    public ObjectSelect<T> prefetch(String path, int semantics) {
        if (path == null) {
            return this;
        }
        this.metaData.addPrefetch(path, semantics);
        return this;
    }

    public ObjectSelect<T> limit(int fetchLimit) {
        this.metaData.setFetchLimit(fetchLimit);
        return this;
    }

    public ObjectSelect<T> offset(int fetchOffset) {
        this.metaData.setFetchOffset(fetchOffset);
        return this;
    }

    public ObjectSelect<T> pageSize(int pageSize) {
        this.metaData.setPageSize(pageSize);
        return this;
    }

    public ObjectSelect<T> statementFetchSize(int size) {
        this.metaData.setStatementFetchSize(size);
        return this;
    }

    public ObjectSelect<T> queryTimeout(int timeout) {
        this.metaData.setQueryTimeout(timeout);
        return this;
    }

    public ObjectSelect<T> cacheStrategy(QueryCacheStrategy strategy) {
        this.setCacheStrategy(strategy);
        this.setCacheGroup(null);
        return this;
    }

    public ObjectSelect<T> cacheStrategy(QueryCacheStrategy strategy, String cacheGroup) {
        return this.cacheStrategy(strategy).cacheGroup(cacheGroup);
    }

    public ObjectSelect<T> cacheGroup(String cacheGroup) {
        this.setCacheGroup(cacheGroup);
        return this;
    }

    public ObjectSelect<T> localCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroup);
    }

    public ObjectSelect<T> localCache() {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public ObjectSelect<T> sharedCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroup);
    }

    public ObjectSelect<T> sharedCache() {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public ObjectSelect<DataRow> fetchDataRows() {
        this.metaData.setFetchingDataRows(true);
        return this;
    }

    public ColumnSelect<Object[]> columns(Property<?> ... properties) {
        return new ColumnSelect(this).columns(properties);
    }

    public <E> ColumnSelect<E> column(Property<E> property) {
        return new ColumnSelect(this).column(property);
    }

    public ColumnSelect<Long> count() {
        return this.column(PropertyFactory.COUNT);
    }

    public ColumnSelect<Long> count(BaseProperty<?> property) {
        return this.column(property.count());
    }

    public <E> ColumnSelect<E> min(ComparableProperty<E> property) {
        return this.column(property.min());
    }

    public <E extends Number> ColumnSelect<E> min(NumericProperty<E> property) {
        return this.column(property.min());
    }

    public <E> ColumnSelect<E> max(ComparableProperty<E> property) {
        return this.column(property.max());
    }

    public <E extends Number> ColumnSelect<E> max(NumericProperty<E> property) {
        return this.column(property.max());
    }

    @Deprecated
    public <E> ColumnSelect<E> avg(org.apache.cayenne.exp.Property<E> property) {
        return this.column(property.avg());
    }

    public <E extends Number> ColumnSelect<E> avg(NumericProperty<E> property) {
        return this.column(property.avg());
    }

    @Deprecated
    public <E extends Number> ColumnSelect<E> sum(org.apache.cayenne.exp.Property<E> property) {
        return this.column(property.sum());
    }

    public <E extends Number> ColumnSelect<E> sum(NumericProperty<E> property) {
        return this.column(property.sum());
    }

    public ObjectSelect<T> distinct() {
        this.distinct = true;
        return this;
    }

    public long selectCount(ObjectContext context) {
        return (Long)this.count().selectOne(context);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    @Override
    public boolean isFetchingDataRows() {
        return this.metaData.isFetchingDataRows();
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        Object root = this.resolveRoot(resolver);
        this.metaData.resolve(root, resolver, this);
        return this.metaData;
    }

    @Override
    protected BaseQueryMetadata getBaseMetaData() {
        return this.metaData;
    }

    @Override
    public Query createQuery(Map<String, ?> parameters) {
        if (this.where == null) {
            return this;
        }
        this.where = this.where.params(parameters, true);
        return this;
    }
}

