/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.testdo.annotation.ArtistAnnotation;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="annotation/cayenne-project.xml")
public class AnnotationIT
extends ServerCase {
    @Inject
    private ObjectContext objectContext;

    @Test
    public void testAvailableCallback() {
        LifecycleCallbackRegistry lifecycleCallbackRegistry = this.objectContext.getEntityResolver().getCallbackRegistry();
        Assert.assertFalse((boolean)lifecycleCallbackRegistry.isEmpty(LifecycleEvent.POST_ADD));
        Assert.assertFalse((boolean)lifecycleCallbackRegistry.isEmpty(LifecycleEvent.PRE_PERSIST));
        Assert.assertFalse((boolean)lifecycleCallbackRegistry.isEmpty(LifecycleEvent.POST_PERSIST));
        Assert.assertFalse((boolean)lifecycleCallbackRegistry.isEmpty(LifecycleEvent.POST_LOAD));
        Assert.assertFalse((boolean)lifecycleCallbackRegistry.isEmpty(LifecycleEvent.PRE_UPDATE));
        Assert.assertFalse((boolean)lifecycleCallbackRegistry.isEmpty(LifecycleEvent.POST_UPDATE));
        Assert.assertFalse((boolean)lifecycleCallbackRegistry.isEmpty(LifecycleEvent.PRE_REMOVE));
        Assert.assertFalse((boolean)lifecycleCallbackRegistry.isEmpty(LifecycleEvent.POST_REMOVE));
    }

    @Test
    public void testWorkCallback() {
        ArtistAnnotation artist = this.objectContext.newObject(ArtistAnnotation.class);
        Assert.assertEquals((Object)artist.getPostCallback(), (Object)"testPostAdd");
        Assert.assertNull((Object)artist.getPreCallback());
        this.objectContext.commitChanges();
        Assert.assertEquals((Object)artist.getPostCallback(), (Object)"testPostPersist");
        Assert.assertEquals((Object)artist.getPreCallback(), (Object)"testPrePersist");
        artist = ObjectSelect.query(ArtistAnnotation.class).selectFirst(this.objectContext);
        Assert.assertEquals((Object)artist.getPostCallback(), (Object)"testPostLoad");
        artist.setPostCallback(null);
        this.objectContext.commitChanges();
        Assert.assertEquals((Object)artist.getPostCallback(), (Object)"testPostUpdate");
        Assert.assertEquals((Object)artist.getPreCallback(), (Object)"testPreUpdate");
        this.objectContext.deleteObject(artist);
        Assert.assertEquals((Object)artist.getPreCallback(), (Object)"testPreRemove");
        this.objectContext.commitChanges();
        Assert.assertEquals((Object)artist.getPostCallback(), (Object)"testPostRemove");
    }
}

