/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ExpressionIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private ServerRuntime runtime;
    @Inject
    private UnitDbAdapter adapter;

    @Test
    public void testMatch() {
        Assert.assertTrue((boolean)(this.context instanceof DataContext));
        DataContext context2 = (DataContext)this.runtime.newContext();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("Equals");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setToArtist(a1);
        p1.setPaintingTitle("painting1");
        this.context.commitChanges();
        Assert.assertNotSame((Object)context2, (Object)this.context);
        List objects = ObjectSelect.query(Painting.class, Painting.TO_ARTIST.eq(a1)).select(context2);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)Painting.TO_ARTIST.eq(a1).match(objects.get(0)));
        a1.setArtistName("newName");
        Assert.assertTrue((boolean)Painting.TO_ARTIST.eq(a1).match(objects.get(0)));
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("Equals");
        this.context.commitChanges();
        Assert.assertFalse((boolean)Painting.TO_ARTIST.eq(a2).match(objects.get(0)));
    }

    @Test
    public void testFirst() {
        ArrayList<Painting> paintingList = new ArrayList<Painting>();
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("x1");
        paintingList.add(p1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("x2");
        paintingList.add(p2);
        Painting p3 = this.context.newObject(Painting.class);
        p3.setPaintingTitle("x3");
        paintingList.add(p3);
        Expression e1 = ExpressionFactory.likeExp("paintingTitle", (Object)"x%");
        Assert.assertSame((Object)p1, e1.first(paintingList));
        Expression e3 = ExpressionFactory.matchExp("paintingTitle", (Object)"x3");
        Assert.assertSame((Object)p3, e3.first(paintingList));
        Expression e4 = ExpressionFactory.matchExp("paintingTitle", (Object)"x4");
        Assert.assertNull(e4.first(paintingList));
    }

    @Test
    public void testLessThanNull() {
        List artists;
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("Picasso");
        this.context.commitChanges();
        try {
            artists = ObjectSelect.query(Artist.class, Artist.ARTIST_NAME.lt((String)null)).select(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.adapter.supportsNullComparison()) {
                throw ex;
            }
            return;
        }
        Assert.assertTrue((String)"Less than 'NULL' never matches anything", (boolean)artists.isEmpty());
    }

    @Test
    public void testInNull() {
        List artists;
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("Picasso");
        this.context.commitChanges();
        try {
            artists = ObjectSelect.query(Artist.class, Artist.ARTIST_NAME.in("Picasso", new String[]{null})).select(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.adapter.supportsNullComparison()) {
                throw ex;
            }
            return;
        }
        Assert.assertEquals((long)1L, (long)artists.size());
    }
}

