/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.BaseHandlerTest;
import org.apache.cayenne.configuration.xml.DbEntityHandler;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.junit.Assert;
import org.junit.Test;

public class DbEntityHandlerTest
extends BaseHandlerTest {
    @Test
    public void testLoad() throws Exception {
        final DataMap map = new DataMap();
        Assert.assertTrue((boolean)map.getDbEntities().isEmpty());
        this.parse("db-entity", new BaseHandlerTest.HandlerFactory(){

            @Override
            public NamespaceAwareNestedTagHandler createHandler(NamespaceAwareNestedTagHandler parent) {
                return new DbEntityHandler(parent, map);
            }
        });
        Assert.assertEquals((long)1L, (long)map.getDbEntities().size());
        DbEntity entity = map.getDbEntity("ARTGROUP");
        Assert.assertNotNull((Object)entity);
        Assert.assertNull((Object)entity.getPrimaryKeyGenerator());
        Assert.assertEquals((long)3L, (long)entity.getAttributes().size());
        Assert.assertEquals((Object)"catalog", (Object)entity.getCatalog());
        Assert.assertEquals((Object)"schema", (Object)entity.getSchema());
        Assert.assertEquals((Object)"name = \"test\"", (Object)entity.getQualifier().toString());
        DbAttribute attribute = entity.getAttribute("GROUP_ID");
        Assert.assertNotNull((Object)attribute);
        Assert.assertTrue((boolean)attribute.isMandatory());
        Assert.assertTrue((boolean)attribute.isPrimaryKey());
        Assert.assertTrue((boolean)attribute.isGenerated());
        Assert.assertEquals((long)4L, (long)attribute.getType());
        attribute = entity.getAttribute("NAME");
        Assert.assertNotNull((Object)attribute);
        Assert.assertTrue((boolean)attribute.isMandatory());
        Assert.assertFalse((boolean)attribute.isPrimaryKey());
        Assert.assertFalse((boolean)attribute.isGenerated());
        Assert.assertEquals((long)100L, (long)attribute.getMaxLength());
        Assert.assertEquals((long)12L, (long)attribute.getType());
        attribute = entity.getAttribute("PARENT_GROUP_ID");
        Assert.assertNotNull((Object)attribute);
        Assert.assertFalse((boolean)attribute.isMandatory());
        Assert.assertFalse((boolean)attribute.isPrimaryKey());
        Assert.assertFalse((boolean)attribute.isGenerated());
        Assert.assertEquals((long)10L, (long)attribute.getScale());
        Assert.assertEquals((long)-7L, (long)attribute.getType());
    }
}

