/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.translator.select.BaseColumnExtractorTest;
import org.apache.cayenne.access.translator.select.DescriptorColumnExtractor;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.generic.DefaultValueComparisonStrategyFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DescriptorColumnExtractorTest
extends BaseColumnExtractorTest {
    @Test
    public void testExtractNoPrefix() {
        DbEntity mockDbEntity = this.createMockDbEntity("mock");
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withMetaData(new MockQueryMetadataBuilder().withDbEntity(mockDbEntity).build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        DataMap dataMap = new DataMap();
        dataMap.addDbEntity(mockDbEntity);
        ObjEntity entity = new ObjEntity();
        entity.setName("mock");
        entity.setDataMap(dataMap);
        entity.setDbEntity(mockDbEntity);
        ObjAttribute attribute = new ObjAttribute();
        attribute.setName("not_name");
        attribute.setDbAttributePath("name");
        attribute.setType("java.lang.Integer");
        entity.addAttribute(attribute);
        dataMap.addObjEntity(entity);
        EntityResolver resolver = new EntityResolver();
        resolver.addDataMap(dataMap);
        resolver.setValueComparisionStrategyFactory(new DefaultValueComparisonStrategyFactory((ValueObjectTypeRegistry)Mockito.mock(ValueObjectTypeRegistry.class)));
        DescriptorColumnExtractor extractor = new DescriptorColumnExtractor(context, resolver.getClassDescriptor("mock"));
        extractor.extract();
        Assert.assertEquals((long)2L, (long)context.getResultNodeList().size());
        ResultNodeDescriptor descriptor0 = context.getResultNodeList().get(0);
        ResultNodeDescriptor descriptor1 = context.getResultNodeList().get(1);
        Assert.assertNull(descriptor0.getProperty());
        Assert.assertNotNull((Object)descriptor0.getNode());
        Assert.assertThat((Object)descriptor0.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor0.isAggregate());
        Assert.assertTrue((boolean)descriptor0.isInDataRow());
        Assert.assertNotNull((Object)descriptor0.getDbAttribute());
        Assert.assertEquals((Object)"name", (Object)descriptor0.getDataRowKey());
        Assert.assertEquals((long)-3L, (long)descriptor0.getJdbcType());
        Assert.assertEquals((Object)"java.lang.Integer", (Object)descriptor0.getJavaType());
        Assert.assertNull(descriptor1.getProperty());
        Assert.assertNotNull((Object)descriptor1.getNode());
        Assert.assertThat((Object)descriptor1.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor1.isAggregate());
        Assert.assertTrue((boolean)descriptor1.isInDataRow());
        Assert.assertEquals((Object)"id", (Object)descriptor1.getDataRowKey());
        Assert.assertNotNull((Object)descriptor1.getDbAttribute());
        Assert.assertEquals((long)-5L, (long)descriptor1.getJdbcType());
    }
}

