/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch.legacy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.translator.batch.legacy.DeleteBatchTranslator;
import org.apache.cayenne.access.translator.batch.legacy.SoftDeleteTranslatorFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.soft_delete.SoftDelete;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
@UseServerRuntime(value="cayenne-soft-delete.xml")
public class SoftDeleteBatchTranslatorIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    protected DbAdapter adapter;
    @Inject
    private DataNode dataNode;
    @Inject
    private UnitDbAdapter unitAdapter;
    @Inject
    private AdhocObjectFactory objectFactory;

    private DeleteBatchTranslator createTranslator(DeleteBatchQuery query) {
        JdbcAdapter adapter = (JdbcAdapter)this.objectFactory.newInstance(JdbcAdapter.class, JdbcAdapter.class.getName());
        return this.createTranslator(query, adapter);
    }

    private DeleteBatchTranslator createTranslator(DeleteBatchQuery query, JdbcAdapter adapter) {
        return (DeleteBatchTranslator)new SoftDeleteTranslatorFactory().translator(query, adapter, null);
    }

    @Test
    public void testCreateSqlString() {
        DbEntity entity = this.context.getEntityResolver().getObjEntity(SoftDelete.class).getDbEntity();
        List<DbAttribute> idAttributes = Collections.singletonList(entity.getAttribute("ID"));
        DeleteBatchQuery deleteQuery = new DeleteBatchQuery(entity, idAttributes, Collections.emptySet(), 1);
        DeleteBatchTranslator builder = this.createTranslator(deleteQuery);
        String generatedSql = builder.getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertEquals((Object)("UPDATE " + entity.getName() + " SET DELETED = ? WHERE ID = ?"), (Object)generatedSql);
    }

    @Test
    public void testCreateSqlStringWithNulls() {
        DbEntity entity = this.context.getEntityResolver().getObjEntity(SoftDelete.class).getDbEntity();
        List<DbAttribute> idAttributes = Arrays.asList(entity.getAttribute("ID"), entity.getAttribute("NAME"));
        Set<String> nullAttributes = Collections.singleton("NAME");
        DeleteBatchQuery deleteQuery = new DeleteBatchQuery(entity, idAttributes, nullAttributes, 1);
        DeleteBatchTranslator builder = this.createTranslator(deleteQuery);
        String generatedSql = builder.getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertEquals((Object)("UPDATE " + entity.getName() + " SET DELETED = ? WHERE ID = ? AND NAME IS NULL"), (Object)generatedSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithIdentifiersQuote() {
        DbEntity entity = this.context.getEntityResolver().getObjEntity(SoftDelete.class).getDbEntity();
        try {
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            List<DbAttribute> idAttributes = Collections.singletonList(entity.getAttribute("ID"));
            DeleteBatchQuery deleteQuery = new DeleteBatchQuery(entity, idAttributes, Collections.emptySet(), 1);
            JdbcAdapter adapter = (JdbcAdapter)this.adapter;
            DeleteBatchTranslator builder = this.createTranslator(deleteQuery, adapter);
            String generatedSql = builder.getSql();
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertEquals((Object)("UPDATE " + charStart + entity.getName() + charEnd + " SET " + charStart + "DELETED" + charEnd + " = ? WHERE " + charStart + "ID" + charEnd + " = ?"), (Object)generatedSql);
        }
        finally {
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdate() throws Exception {
        final DbEntity entity = this.context.getEntityResolver().getObjEntity(SoftDelete.class).getDbEntity();
        BatchTranslatorFactory oldFactory = this.dataNode.getBatchTranslatorFactory();
        try {
            this.dataNode.setBatchTranslatorFactory(new SoftDeleteTranslatorFactory());
            final SoftDelete test = this.context.newObject(SoftDelete.class);
            test.setName("SoftDeleteBatchQueryBuilderTest");
            this.context.commitChanges();
            new ParallelTestContainer(){

                protected void assertResult() {
                    Expression exp = ExpressionFactory.matchExp("name", (Object)test.getName());
                    Assert.assertEquals((long)1L, (long)ObjectSelect.query(SoftDelete.class, exp).selectCount(SoftDeleteBatchTranslatorIT.this.context));
                    exp = ExpressionFactory.matchDbExp("DELETED", true);
                    Assert.assertEquals((long)0L, (long)ObjectSelect.query(SoftDelete.class, exp).selectCount(SoftDeleteBatchTranslatorIT.this.context));
                }
            }.runTest(200L);
            this.context.deleteObjects(test);
            Assert.assertEquals((long)test.getPersistenceState(), (long)6L);
            this.context.commitChanges();
            new ParallelTestContainer(){

                protected void assertResult() {
                    Expression exp = ExpressionFactory.matchExp("name", (Object)test.getName());
                    Assert.assertEquals((long)0L, (long)ObjectSelect.query(SoftDelete.class, exp).selectCount(SoftDeleteBatchTranslatorIT.this.context));
                    SQLTemplate template = new SQLTemplate(entity, "SELECT * FROM SOFT_DELETE");
                    template.setFetchingDataRows(true);
                    Assert.assertEquals((long)1L, (long)SoftDeleteBatchTranslatorIT.this.context.performQuery(template).size());
                }
            }.runTest(200L);
        }
        finally {
            this.context.performQuery(new SQLTemplate(entity, "DELETE FROM SOFT_DELETE"));
            this.dataNode.setBatchTranslatorFactory(oldFactory);
        }
    }
}

