/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationVisitor;
import org.apache.cayenne.access.sqlbuilder.StringBuilderAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.junit.Assert;

class BaseSqlBuilderTest {
    BaseSqlBuilderTest() {
    }

    void assertSQL(String expected, Node node) {
        this.assertSQL(expected, node, new StringBuilderAppendable());
    }

    void assertQuotedSQL(String expected, Node node) {
        this.assertSQL(expected, node, new MockQuotedStringBuilderAppendable());
    }

    void assertSQL(String expected, Node node, QuotingAppendable appendable) {
        SQLGenerationVisitor visitor = new SQLGenerationVisitor(appendable);
        node.visit(visitor);
        Assert.assertEquals((Object)expected, (Object)visitor.getSQLString());
    }

    static class MockQuotedStringBuilderAppendable
    extends StringBuilderAppendable {
        MockQuotedStringBuilderAppendable() {
        }

        @Override
        public QuotingAppendable appendQuoted(CharSequence csq) {
            this.builder.append('`').append(csq).append('`');
            return this;
        }
    }
}

