/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataChannelQueryFilter;
import org.apache.cayenne.DataChannelQueryFilterChain;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.DataChannelSyncFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.ListResponse;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataDomainFiltersIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testDefaultFilters() {
        DataDomain domain = this.runtime.getDataDomain();
        Assert.assertEquals((long)0L, (long)domain.queryFilters.size());
        Assert.assertEquals((long)1L, (long)domain.syncFilters.size());
    }

    @Test
    public void testOnQuery_FilterOrdering() {
        DataDomain domain = this.runtime.getDataDomain();
        ArrayList results = new ArrayList();
        DataChannelQueryFilter f1 = (originatingContext, query, filterChain) -> {
            results.add("f1start");
            QueryResponse response = filterChain.onQuery(originatingContext, query);
            results.add("f1end");
            return response;
        };
        DataChannelQueryFilter f2 = (originatingContext, query, filterChain) -> {
            results.add("f2start");
            QueryResponse response = filterChain.onQuery(originatingContext, query);
            results.add("f2end");
            return response;
        };
        domain.queryFilters.add(f1);
        domain.queryFilters.add(f2);
        ObjectSelect<Artist> query2 = ObjectSelect.query(Artist.class);
        QueryResponse response = domain.onQuery(this.context, query2);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)"f2start", results.get(0));
        Assert.assertEquals((Object)"f1start", results.get(1));
        Assert.assertEquals((Object)"f1end", results.get(2));
        Assert.assertEquals((Object)"f2end", results.get(3));
    }

    @Test
    public void testOnSync_FilterOrdering() {
        DataDomain domain = this.runtime.getDataDomain();
        ArrayList results = new ArrayList();
        DataChannelSyncFilter f1 = (originatingContext, changes, syncType, filterChain) -> {
            results.add("f1start");
            GraphDiff response = filterChain.onSync(originatingContext, changes, syncType);
            results.add("f1end");
            return response;
        };
        DataChannelSyncFilter f2 = (originatingContext, changes, syncType, filterChain) -> {
            results.add("f2start");
            GraphDiff response = filterChain.onSync(originatingContext, changes, syncType);
            results.add("f2end");
            return response;
        };
        domain.syncFilters.add(f1);
        domain.syncFilters.add(f2);
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("AAA");
        this.context.commitChanges();
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)"f2start", results.get(0));
        Assert.assertEquals((Object)"f1start", results.get(1));
        Assert.assertEquals((Object)"f1end", results.get(2));
        Assert.assertEquals((Object)"f2end", results.get(3));
    }

    @Test
    public void testOnQuery_Blocking() {
        DataDomain domain = this.runtime.getDataDomain();
        ListResponse r1 = new ListResponse();
        ListResponse r2 = new ListResponse();
        DataChannelQueryFilter f1 = (originatingContext, query, filterChain) -> r1;
        DataChannelQueryFilter f2 = (originatingContext, query, filterChain) -> r2;
        domain.queryFilters.add(f1);
        domain.queryFilters.add(f2);
        ObjectSelect<Artist> query2 = ObjectSelect.query(Artist.class);
        QueryResponse response = domain.onQuery(this.context, query2);
        Assert.assertSame((Object)r2, (Object)response);
    }

    @Test
    public void testSyncAndQueryFilter() {
        ComplexFilter complexFilter = new ComplexFilter();
        DataDomain domain = this.runtime.getDataDomain();
        domain.addQueryFilter(complexFilter);
        domain.addSyncFilter(complexFilter);
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("AAA");
        this.context.commitChanges();
        Assert.assertEquals((long)2L, (long)complexFilter.results.size());
        Assert.assertEquals((Object)"onSync", complexFilter.results.get(0));
        Assert.assertEquals((Object)"postPersist", complexFilter.results.get(1));
    }

    private static class ComplexFilter
    implements DataChannelQueryFilter,
    DataChannelSyncFilter {
        private List<String> results = new ArrayList<String>();

        private ComplexFilter() {
        }

        @Override
        public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelQueryFilterChain filterChain) {
            this.results.add("onQuery");
            return filterChain.onQuery(originatingContext, query);
        }

        @Override
        public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelSyncFilterChain filterChain) {
            this.results.add("onSync");
            return filterChain.onSync(originatingContext, changes, syncType);
        }

        @PostPersist
        public void postPersist(Object object) {
            this.results.add("postPersist");
        }
    }
}

