/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextRollbackIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime serverRuntime;

    @Test
    public void testRollbackNew() {
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName("a");
        Painting p1 = (Painting)this.context.newObject("Painting");
        p1.setPaintingTitle("p1");
        p1.setToArtist(artist);
        Painting p2 = (Painting)this.context.newObject("Painting");
        p2.setPaintingTitle("p2");
        p2.setToArtist(artist);
        Painting p3 = (Painting)this.context.newObject("Painting");
        p3.setPaintingTitle("p3");
        p3.setToArtist(artist);
        Assert.assertEquals((Object)artist, (Object)p1.getToArtist());
        Assert.assertEquals((long)3L, (long)artist.getPaintingArray().size());
        this.context.rollbackChanges();
        Assert.assertEquals((long)1L, (long)artist.getPersistenceState());
    }

    @Test
    public void testRollbackNewObject() {
        String artistName = "revertTestArtist";
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName(artistName);
        this.context.rollbackChanges();
        Assert.assertEquals((long)1L, (long)artist.getPersistenceState());
        this.context.commitChanges();
        DataContext freshContext = (DataContext)this.serverRuntime.newContext();
        Assert.assertNotSame((Object)this.context, (Object)freshContext);
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq(artistName));
        List queryResults = query.select(freshContext);
        Assert.assertEquals((long)0L, (long)queryResults.size());
    }

    @Test
    public void testRollbackWithMultipleNewObjects() {
        String artistName = "rollbackTestArtist";
        String paintingTitle = "rollbackTestPainting";
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName(artistName);
        Painting painting = (Painting)this.context.newObject("Painting");
        painting.setPaintingTitle(paintingTitle);
        painting.setToArtist(artist);
        this.context.rollbackChanges();
        Assert.assertEquals((long)1L, (long)artist.getPersistenceState());
        this.context.commitChanges();
        DataContext freshContext = (DataContext)this.serverRuntime.newContext();
        Assert.assertNotSame((Object)this.context, (Object)freshContext);
        List queryResults = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq(artistName)).select(freshContext);
        Assert.assertEquals((long)0L, (long)queryResults.size());
    }

    @Test
    public void testRollbackRelationshipModification() {
        String artistName = "relationshipModArtist";
        String paintingTitle = "relationshipTestPainting";
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName(artistName);
        Painting painting = (Painting)this.context.newObject("Painting");
        painting.setPaintingTitle(paintingTitle);
        painting.setToArtist(artist);
        this.context.commitChanges();
        painting.setToArtist(null);
        Assert.assertEquals((long)0L, (long)artist.getPaintingArray().size());
        this.context.rollbackChanges();
        Assert.assertTrue((boolean)((ValueHolder)((Object)artist.getPaintingArray())).isFault());
        Assert.assertEquals((long)1L, (long)artist.getPaintingArray().size());
        Assert.assertEquals((Object)artist, (Object)painting.getToArtist());
        Assert.assertEquals((long)1L, (long)artist.getPaintingArray().size());
        this.context.commitChanges();
        DataContext freshContext = (DataContext)this.serverRuntime.newContext();
        Assert.assertNotSame((Object)this.context, (Object)freshContext);
        List queryResults = ObjectSelect.query(Painting.class).where(Painting.PAINTING_TITLE.eq(paintingTitle)).select(freshContext);
        Assert.assertEquals((long)1L, (long)queryResults.size());
        Painting queriedPainting = (Painting)queryResults.get(0);
        Assert.assertEquals((Object)artistName, (Object)queriedPainting.getToArtist().getArtistName());
    }

    @Test
    public void testRollbackDeletedObject() {
        String artistName = "deleteTestArtist";
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName(artistName);
        this.context.commitChanges();
        this.context.deleteObjects(artist);
        this.context.rollbackChanges();
        Assert.assertEquals((long)5L, (long)artist.getPersistenceState());
        this.context.commitChanges();
        DataContext freshContext = (DataContext)this.serverRuntime.newContext();
        Assert.assertNotSame((Object)this.context, (Object)freshContext);
        List queryResults = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq(artistName)).select(this.context);
        Assert.assertEquals((long)1L, (long)queryResults.size());
    }

    @Test
    public void testRollbackModifiedObject() {
        String artistName = "initialTestArtist";
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName(artistName);
        this.context.commitChanges();
        artist.setArtistName("a new value");
        this.context.rollbackChanges();
        Assert.assertEquals((Object)artistName, (Object)artist.getArtistName());
        this.context.commitChanges();
        DataContext freshContext = (DataContext)this.serverRuntime.newContext();
        Assert.assertNotSame((Object)this.context, (Object)freshContext);
        List queryResults = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq(artistName)).select(freshContext);
        Assert.assertEquals((long)1L, (long)queryResults.size());
    }
}

