/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-meaningful-pk.xml")
public class DataContextEJBQLDeletePKIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tMeaningfulPKTest1Table;

    @Before
    public void setUp() throws Exception {
        this.tMeaningfulPKTest1Table = new TableHelper(this.dbHelper, "MEANINGFUL_PK_TEST1");
        this.tMeaningfulPKTest1Table.setColumns(new String[]{"PK_ATTRIBUTE", "DESCR", "INT_ATTRIBUTE"});
    }

    protected void createMeaningfulPKDataSet() throws Exception {
        for (int i = 1; i <= 33; ++i) {
            this.tMeaningfulPKTest1Table.insert(new Object[]{i, "a" + i, 0});
        }
    }

    @Test
    public void testDeleteIdVar() throws Exception {
        this.createMeaningfulPKDataSet();
        EJBQLQuery q = new EJBQLQuery("select m.pkAttribute from MeaningfulPKTest1 m");
        List id = this.context.performQuery(q);
        String ejbql = "delete from MeaningfulPKTest1 m WHERE m.pkAttribute in (:id)";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("id", (Object)id);
        QueryResponse result = this.context.performGenericQuery(query);
        int[] count = result.firstUpdateCount();
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        Assert.assertEquals((long)33L, (long)count[0]);
    }
}

