/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.ObjectContextChangeLog;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.NodeCreateOperation;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class ObjectContextChangeLogTest {
    @Test
    public void testReset() {
        ObjectContextChangeLog recorder = new ObjectContextChangeLog();
        Assert.assertNotNull((Object)recorder.getDiffs());
        Assert.assertTrue((boolean)recorder.getDiffs().isNoop());
        recorder.addOperation(new NodeCreateOperation(new Object()));
        Assert.assertNotNull((Object)recorder.getDiffs());
        Assert.assertFalse((boolean)recorder.getDiffs().isNoop());
        recorder.reset();
        Assert.assertNotNull((Object)recorder.getDiffs());
        Assert.assertTrue((boolean)recorder.getDiffs().isNoop());
        recorder.addOperation(new NodeCreateOperation(new Object()));
        GraphDiff diff = recorder.getDiffs();
        Assert.assertFalse((boolean)diff.isNoop());
        recorder.reset();
        Assert.assertFalse((boolean)diff.isNoop());
    }

    @Test
    public void testGetDiffs() {
        ObjectContextChangeLog recorder = new ObjectContextChangeLog();
        recorder.addOperation(new NodeCreateOperation(new Object()));
        CompoundDiff diff = (CompoundDiff)recorder.getDiffs();
        Assert.assertEquals((long)1L, (long)diff.getDiffs().size());
        recorder.addOperation(new NodeCreateOperation(new Object()));
        Assert.assertEquals((long)1L, (long)diff.getDiffs().size());
        CompoundDiff diff2 = (CompoundDiff)recorder.getDiffs();
        Assert.assertEquals((long)2L, (long)diff2.getDiffs().size());
    }

    @Test
    public void testGetDiffsSerializable() throws Exception {
        ObjectContextChangeLog recorder = new ObjectContextChangeLog();
        recorder.addOperation(new NodeCreateOperation(ObjectId.of("test")));
        CompoundDiff diff = (CompoundDiff)recorder.getDiffs();
        CompoundDiff clone = Util.cloneViaSerialization(diff);
        Assert.assertNotNull((Object)clone);
        Assert.assertTrue((boolean)(clone instanceof CompoundDiff));
        CompoundDiff d1 = clone;
        Assert.assertEquals((long)1L, (long)d1.getDiffs().size());
    }
}

