/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.FluentSelectPrefetchRouterAction;
import org.apache.cayenne.query.MockQueryRouter;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class FluentSelectPrefetchRouterActionIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testPaintings1() {
        ObjEntity paintingEntity = this.resolver.getObjEntity(Painting.class);
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class, Artist.ARTIST_NAME.eq("abc")).prefetch(Artist.PAINTING_ARRAY.disjoint());
        FluentSelectPrefetchRouterAction action = new FluentSelectPrefetchRouterAction();
        MockQueryRouter router = new MockQueryRouter();
        action.route(query, router, this.resolver);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        PrefetchSelectQuery prefetch = (PrefetchSelectQuery)router.getQueries().get(0);
        Assert.assertEquals((Object)paintingEntity.getName(), (Object)prefetch.entityName);
        Assert.assertEquals((Object)ExpressionFactory.exp("db:toArtist.ARTIST_NAME = 'abc'", new Object[0]), (Object)prefetch.getWhere());
    }

    @Test
    public void testPrefetchPaintings2() {
        ObjEntity paintingEntity = this.resolver.getObjEntity(Painting.class);
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("abc")).or(Artist.ARTIST_NAME.eq("xyz")).prefetch(Artist.PAINTING_ARRAY.disjoint());
        FluentSelectPrefetchRouterAction action = new FluentSelectPrefetchRouterAction();
        MockQueryRouter router = new MockQueryRouter();
        action.route(query, router, this.resolver);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        PrefetchSelectQuery prefetch = (PrefetchSelectQuery)router.getQueries().get(0);
        Assert.assertEquals((Object)paintingEntity.getName(), (Object)prefetch.entityName);
        Assert.assertEquals((Object)ExpressionFactory.exp("db:toArtist.ARTIST_NAME = 'abc' or db:toArtist.ARTIST_NAME = 'xyz'", new Object[0]), (Object)prefetch.getWhere());
    }

    @Test
    public void testGalleries() {
        ObjEntity galleryEntity = this.resolver.getObjEntity(Gallery.class);
        ObjectSelect<Artist> query = ObjectSelect.query(Artist.class, Artist.ARTIST_NAME.eq("abc")).prefetch(Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY).disjoint());
        FluentSelectPrefetchRouterAction action = new FluentSelectPrefetchRouterAction();
        MockQueryRouter router = new MockQueryRouter();
        action.route(query, router, this.resolver);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        PrefetchSelectQuery prefetch = (PrefetchSelectQuery)router.getQueries().get(0);
        Assert.assertEquals((Object)galleryEntity.getName(), (Object)prefetch.entityName);
        Assert.assertEquals((Object)ExpressionFactory.exp("db:paintingArray.toArtist.ARTIST_NAME = 'abc'", new Object[0]), (Object)prefetch.getWhere());
    }
}

