/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.CompoundPainting;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DefaultSelectTranslatorIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private UnitDbAdapter unitAdapter;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private JdbcEventLogger logger;
    @Inject
    private DataNode dataNode;

    @Test
    public void testCreateSqlString1() throws Exception {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class, Artist.ARTIST_NAME.like("a%")).orderBy(Artist.DATE_OF_BIRTH.asc());
        DefaultSelectTranslator defaultSelectTranslator = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        String generatedSql = defaultSelectTranslator.getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertFalse((boolean)defaultSelectTranslator.hasJoins());
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.indexOf(" WHERE ") > generatedSql.indexOf(" FROM ") ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.indexOf(" ORDER BY ") > generatedSql.indexOf(" WHERE ") ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEntityQualifier() throws Exception {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
        DbEntity middleEntity = this.context.getEntityResolver().getDbEntity("ARTIST_GROUP");
        DefaultSelectTranslator transl = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        entity.setQualifier(ExpressionFactory.exp("ARTIST_NAME = \"123\"", new Object[0]));
        middleEntity.setQualifier(ExpressionFactory.exp("GROUP_ID = 1987", new Object[0]));
        try {
            String generatedSql = transl.getSql();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
            Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
            if (generatedSql.contains("RTRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) =") > generatedSql.indexOf("RTRIM(") ? 1 : 0) != 0);
            } else if (generatedSql.contains("TRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) =") > generatedSql.indexOf("TRIM(") ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME =") > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            entity.setQualifier(null);
            middleEntity.setQualifier(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEntityQualifier_OuterJoin() throws Exception {
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).orderBy(Painting.TO_ARTIST.outer().dot(Artist.ARTIST_NAME).asc());
        DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
        DbEntity middleEntity = this.context.getEntityResolver().getDbEntity("ARTIST_GROUP");
        DefaultSelectTranslator transl = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        entity.setQualifier(ExpressionFactory.exp("ARTIST_NAME = \"123\"", new Object[0]));
        middleEntity.setQualifier(ExpressionFactory.exp("GROUP_ID = 1987", new Object[0]));
        try {
            String generatedSql = transl.getSql();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
            Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
            if (generatedSql.contains("RTRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) =") > generatedSql.indexOf("RTRIM(") ? 1 : 0) != 0);
            } else if (generatedSql.contains("TRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) =") > generatedSql.indexOf("TRIM(") ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME =") > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            entity.setQualifier(null);
            middleEntity.setQualifier(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEntityQualifier_FlattenedRel() throws Exception {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class, Artist.GROUP_ARRAY.dot(ArtGroup.NAME).eq("bar"));
        DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
        DbEntity middleEntity = this.context.getEntityResolver().getDbEntity("ARTIST_GROUP");
        DefaultSelectTranslator transl = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        entity.setQualifier(ExpressionFactory.exp("ARTIST_NAME = \"123\"", new Object[0]));
        middleEntity.setQualifier(ExpressionFactory.exp("GROUP_ID = 1987", new Object[0]));
        try {
            String generatedSql = transl.getSql();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
            Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
            if (generatedSql.contains("RTRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) =") > generatedSql.indexOf("RTRIM(") ? 1 : 0) != 0);
            } else if (generatedSql.contains("TRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) =") > generatedSql.indexOf("TRIM(") ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME =") > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            entity.setQualifier(null);
            middleEntity.setQualifier(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDbEntityQualifier_RelatedMatch() throws Exception {
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class, Painting.TO_ARTIST.dot(Artist.ARTIST_NAME).eq("foo"));
        DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
        DbEntity middleEntity = this.context.getEntityResolver().getDbEntity("ARTIST_GROUP");
        DefaultSelectTranslator transl = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        entity.setQualifier(ExpressionFactory.exp("ARTIST_NAME = \"123\"", new Object[0]));
        middleEntity.setQualifier(ExpressionFactory.exp("GROUP_ID = 1987", new Object[0]));
        try {
            String generatedSql = transl.getSql();
            Assert.assertNotNull((Object)generatedSql);
            Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
            Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
            if (generatedSql.contains("RTRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) =") > generatedSql.indexOf("RTRIM(") ? 1 : 0) != 0);
            } else if (generatedSql.contains("TRIM")) {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME) =") > generatedSql.indexOf("TRIM(") ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((generatedSql.indexOf("ARTIST_NAME =") > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            entity.setQualifier(null);
            middleEntity.setQualifier(null);
        }
    }

    @Test
    @Deprecated
    public void testCreateSqlString2() throws Exception {
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.setDistinct(true);
        String generatedSql = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT DISTINCT"));
    }

    @Test
    public void testCreateSqlString5() throws Exception {
        ObjectSelect<ArtistExhibit> q = ObjectSelect.query(ArtistExhibit.class).where(ArtistExhibit.TO_ARTIST.dot(Artist.ARTIST_NAME).like("a%")).and(ArtistExhibit.TO_EXHIBIT.dot(Exhibit.TO_GALLERY).dot(Gallery.PAINTING_ARRAY).dot(Painting.TO_ARTIST).dot(Artist.ARTIST_NAME).like("a%"));
        String generatedSql = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.indexOf(" WHERE ") > generatedSql.indexOf(" FROM ") ? 1 : 0) != 0);
        int ind1 = generatedSql.indexOf("ARTIST t", generatedSql.indexOf(" FROM "));
        Assert.assertTrue((ind1 > 0 ? 1 : 0) != 0);
        int ind2 = generatedSql.indexOf("ARTIST t", ind1 + 1);
        Assert.assertTrue((ind2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.charAt(ind1 + "ARTIST t".length()) != generatedSql.charAt(ind2 + "ARTIST t".length()) ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString6() throws Exception {
        ObjectSelect<ArtistExhibit> q = ObjectSelect.query(ArtistExhibit.class).where(ArtistExhibit.TO_ARTIST.dot(Artist.ARTIST_NAME).like("a%")).and(ArtistExhibit.TO_ARTIST.dot(Artist.PAINTING_ARRAY).dot(Painting.PAINTING_TITLE).like("p%"));
        String generatedSql = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        Assert.assertTrue((generatedSql.indexOf(" FROM ") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((generatedSql.indexOf(" WHERE ") > generatedSql.indexOf(" FROM ") ? 1 : 0) != 0);
        int ind1 = generatedSql.indexOf("ARTIST t", generatedSql.indexOf(" FROM "));
        Assert.assertTrue((ind1 > 0 ? 1 : 0) != 0);
        int ind2 = generatedSql.indexOf("ARTIST t", ind1 + 1);
        Assert.assertTrue((String)generatedSql, (ind2 < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString7() throws Exception {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(Artist.DATE_OF_BIRTH.gt(new Date())).and(Artist.DATE_OF_BIRTH.lt(new Date()));
        String generatedSql = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        int i1 = generatedSql.indexOf(" FROM ");
        Assert.assertTrue((i1 > 0 ? 1 : 0) != 0);
        int i2 = generatedSql.indexOf(" WHERE ");
        Assert.assertTrue((i2 > i1 ? 1 : 0) != 0);
        int i3 = generatedSql.indexOf("DATE_OF_BIRTH", i2 + 1);
        Assert.assertTrue((i3 > i2 ? 1 : 0) != 0);
        int i4 = generatedSql.indexOf("DATE_OF_BIRTH", i3 + 1);
        Assert.assertTrue((String)("No second DOB comparison: " + i4 + ", " + i3), (i4 > i3 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString8() throws Exception {
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.dot(Artist.DATE_OF_BIRTH).gt(new Date())).and(Painting.TO_ARTIST.dot(Artist.DATE_OF_BIRTH).lt(new Date()));
        String generatedSql = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
        Assert.assertNotNull((Object)generatedSql);
        Assert.assertTrue((boolean)generatedSql.startsWith("SELECT "));
        int i1 = generatedSql.indexOf(" FROM ");
        Assert.assertTrue((i1 > 0 ? 1 : 0) != 0);
        int i2 = generatedSql.indexOf(" WHERE ");
        Assert.assertTrue((i2 > i1 ? 1 : 0) != 0);
        int i3 = generatedSql.indexOf("DATE_OF_BIRTH", i2 + 1);
        Assert.assertTrue((i3 > i2 ? 1 : 0) != 0);
        int i4 = generatedSql.indexOf("DATE_OF_BIRTH", i3 + 1);
        Assert.assertTrue((String)("No second DOB comparison: " + i4 + ", " + i3), (i4 > i3 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString9() throws Exception {
        ObjectSelect<CompoundPainting> q = ObjectSelect.query(CompoundPainting.class, CompoundPainting.ARTIST_NAME.like("a%"));
        String sql = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
        Assert.assertNotNull((Object)sql);
        Assert.assertTrue((boolean)sql.startsWith("SELECT "));
        int i1 = sql.indexOf(" FROM ");
        Assert.assertTrue((i1 > 0 ? 1 : 0) != 0);
        int i2 = sql.indexOf("PAINTING");
        Assert.assertTrue((i2 > 0 ? 1 : 0) != 0);
        int i3 = sql.indexOf("ARTIST");
        Assert.assertTrue((i3 > 0 ? 1 : 0) != 0);
        int i4 = sql.indexOf("GALLERY");
        Assert.assertTrue((i4 > 0 ? 1 : 0) != 0);
        int i5 = sql.indexOf("PAINTING_INFO");
        Assert.assertTrue((i5 > 0 ? 1 : 0) != 0);
        int i6 = sql.indexOf("ARTIST_NAME");
        Assert.assertTrue((i6 > 0 ? 1 : 0) != 0);
        int i7 = sql.indexOf("ESTIMATED_PRICE");
        Assert.assertTrue((i7 > 0 ? 1 : 0) != 0);
        int i8 = sql.indexOf("GALLERY_NAME");
        Assert.assertTrue((i8 > 0 ? 1 : 0) != 0);
        int i9 = sql.indexOf("PAINTING_TITLE");
        Assert.assertTrue((i9 > 0 ? 1 : 0) != 0);
        int i10 = sql.indexOf("TEXT_REVIEW");
        Assert.assertTrue((i10 > 0 ? 1 : 0) != 0);
        int i11 = sql.indexOf("PAINTING_ID");
        Assert.assertTrue((i11 > 0 ? 1 : 0) != 0);
        int i12 = sql.indexOf("ARTIST_ID");
        Assert.assertTrue((i12 > 0 ? 1 : 0) != 0);
        int i13 = sql.indexOf("GALLERY_ID");
        Assert.assertTrue((i13 > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSqlString10() throws Exception {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.joint());
        DefaultSelectTranslator transl = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        String sql = transl.getSql();
        Assert.assertNotNull((Object)sql);
        Assert.assertTrue((boolean)sql.startsWith("SELECT "));
        int i1 = sql.indexOf("ARTIST_ID");
        Assert.assertTrue((String)sql, (i1 > 0 ? 1 : 0) != 0);
        int i2 = sql.indexOf("FROM");
        Assert.assertTrue((String)sql, (i2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)sql, (sql.indexOf("PAINTING_ID") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)transl.hasJoins());
    }

    @Test
    public void testCreateSqlString11() throws Exception {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).eq("a")).prefetch(Artist.PAINTING_ARRAY.joint());
        DefaultSelectTranslator transl = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        transl.getSql();
        Assert.assertTrue((boolean)transl.hasJoins());
    }

    @Test
    public void testCreateSqlString12() throws Exception {
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.joint());
        DefaultSelectTranslator transl = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        String sql = transl.getSql();
        Assert.assertNotNull((Object)sql);
        Assert.assertTrue((boolean)sql.startsWith("SELECT "));
        int i1 = sql.indexOf("ARTIST_ID");
        Assert.assertTrue((String)sql, (i1 > 0 ? 1 : 0) != 0);
        int i2 = sql.indexOf("FROM");
        Assert.assertTrue((String)sql, (i2 > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)sql, (sql.indexOf("PAINTING_ID") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)transl.hasJoins());
    }

    @Test
    public void testCreateSqlString13() throws Exception {
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch("invalid.invalid", 1);
        try {
            new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
            Assert.fail((String)"Invalid jointPrefetch must have thrown...");
        }
        catch (ExpressionException expressionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithQuoteSqlIdentifiers() throws Exception {
        try {
            ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).orderBy(Artist.DATE_OF_BIRTH.asc());
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            String s = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
            Assert.assertTrue((boolean)s.startsWith("SELECT "));
            int iFrom = s.indexOf(" FROM ");
            Assert.assertTrue((iFrom > 0 ? 1 : 0) != 0);
            int artistName = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_NAME" + charEnd);
            Assert.assertTrue((artistName > 0 && artistName < iFrom ? 1 : 0) != 0);
            int artistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((artistId > 0 && artistId < iFrom ? 1 : 0) != 0);
            int dateOfBirth = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd);
            Assert.assertTrue((dateOfBirth > 0 && dateOfBirth < iFrom ? 1 : 0) != 0);
            int iArtist = s.indexOf(charStart + "ARTIST" + charEnd + " " + charStart + "t0" + charEnd);
            Assert.assertTrue((iArtist > iFrom ? 1 : 0) != 0);
            int iOrderBy = s.indexOf(" ORDER BY ");
            int dateOfBirth2 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd, iOrderBy);
            Assert.assertTrue((iOrderBy > iArtist ? 1 : 0) != 0);
            Assert.assertTrue((dateOfBirth2 > iOrderBy ? 1 : 0) != 0);
        }
        finally {
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithQuoteSqlIdentifiers2() throws Exception {
        try {
            ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(Artist.DATE_OF_BIRTH.gt(new Date())).and(Artist.DATE_OF_BIRTH.lt(new Date()));
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            String s = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
            Assert.assertTrue((boolean)s.startsWith("SELECT "));
            int iFrom = s.indexOf(" FROM ");
            Assert.assertTrue((iFrom > 0 ? 1 : 0) != 0);
            int artistName = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_NAME" + charEnd);
            Assert.assertTrue((artistName > 0 && artistName < iFrom ? 1 : 0) != 0);
            int artistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((artistId > 0 && artistId < iFrom ? 1 : 0) != 0);
            int dateOfBirth = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd);
            Assert.assertTrue((dateOfBirth > 0 && dateOfBirth < iFrom ? 1 : 0) != 0);
            int iArtist = s.indexOf(charStart + "ARTIST" + charEnd + " " + charStart + "t0" + charEnd);
            Assert.assertTrue((iArtist > iFrom ? 1 : 0) != 0);
            int iWhere = s.indexOf(" WHERE ");
            Assert.assertTrue((iWhere > iArtist ? 1 : 0) != 0);
            int dateOfBirth2 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd + " > ?");
            Assert.assertTrue((dateOfBirth2 > iWhere ? 1 : 0) != 0);
            int iAnd = s.indexOf(" AND ");
            Assert.assertTrue((iAnd > iWhere ? 1 : 0) != 0);
            int dateOfBirth3 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd + " < ?");
            Assert.assertTrue((dateOfBirth3 > iAnd ? 1 : 0) != 0);
        }
        finally {
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithQuoteSqlIdentifiers3() throws Exception {
        try {
            ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).eq("a")).prefetch(Artist.PAINTING_ARRAY.joint());
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            String s = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
            Assert.assertTrue((String)s, (boolean)s.startsWith("SELECT DISTINCT "));
            int iFrom = s.indexOf(" FROM ");
            Assert.assertTrue((String)s, (iFrom > 0 ? 1 : 0) != 0);
            int artistName = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_NAME" + charEnd);
            Assert.assertTrue((String)s, (artistName > 0 && artistName < iFrom ? 1 : 0) != 0);
            int artistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((String)s, (artistId > 0 && artistId < iFrom ? 1 : 0) != 0);
            int dateOfBirth = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd);
            Assert.assertTrue((String)s, (dateOfBirth > 0 && dateOfBirth < iFrom ? 1 : 0) != 0);
            int estimatedPrice = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ESTIMATED_PRICE" + charEnd);
            Assert.assertTrue((String)s, (estimatedPrice > 0 && estimatedPrice < iFrom ? 1 : 0) != 0);
            int paintingDescription = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "PAINTING_DESCRIPTION" + charEnd);
            Assert.assertTrue((String)s, (paintingDescription > 0 && paintingDescription < iFrom ? 1 : 0) != 0);
            int paintingTitle = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "PAINTING_TITLE" + charEnd);
            Assert.assertTrue((String)s, (paintingTitle > 0 && paintingTitle < iFrom ? 1 : 0) != 0);
            int artistIdT1 = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((String)s, (artistIdT1 > 0 && artistIdT1 < iFrom ? 1 : 0) != 0);
            int galleryId = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "GALLERY_ID" + charEnd);
            Assert.assertTrue((String)s, (galleryId > 0 && galleryId < iFrom ? 1 : 0) != 0);
            int paintingId = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "PAINTING_ID" + charEnd);
            Assert.assertTrue((String)s, (paintingId > 0 && paintingId < iFrom ? 1 : 0) != 0);
            int iArtist = s.indexOf(charStart + "ARTIST" + charEnd + " " + charStart + "t0" + charEnd);
            Assert.assertTrue((String)s, (iArtist > iFrom ? 1 : 0) != 0);
            int iLeftJoin = s.indexOf("LEFT JOIN");
            Assert.assertTrue((String)s, (iLeftJoin > iFrom ? 1 : 0) != 0);
            int iPainting = s.indexOf(charStart + "PAINTING" + charEnd + " " + charStart + "t1" + charEnd);
            Assert.assertTrue((String)s, (iPainting > iLeftJoin ? 1 : 0) != 0);
            int iOn = s.indexOf(" ON ");
            Assert.assertTrue((String)s, (iOn > iLeftJoin ? 1 : 0) != 0);
            int iArtistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iLeftJoin);
            Assert.assertTrue((String)s, (iArtistId > iOn ? 1 : 0) != 0);
            int iArtistIdT1 = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iLeftJoin);
            Assert.assertTrue((String)s, (iArtistIdT1 > iOn ? 1 : 0) != 0);
            int i = s.indexOf("=", iLeftJoin);
            Assert.assertTrue((String)s, (iArtistIdT1 > i || iArtistId > i ? 1 : 0) != 0);
            int iJoin = s.indexOf("JOIN");
            Assert.assertTrue((String)s, (iJoin > iLeftJoin ? 1 : 0) != 0);
            int iPainting2 = s.indexOf(charStart + "PAINTING" + charEnd + " " + charStart + "t2" + charEnd);
            Assert.assertTrue((String)s, (iPainting2 > iJoin ? 1 : 0) != 0);
            int iOn2 = s.indexOf(" ON ");
            Assert.assertTrue((String)s, (iOn2 > iJoin ? 1 : 0) != 0);
            int iArtistId2 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iJoin);
            Assert.assertTrue((String)s, (iArtistId2 > iOn2 ? 1 : 0) != 0);
            int iArtistId2T2 = s.indexOf(charStart + "t2" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iJoin);
            Assert.assertTrue((String)s, (iArtistId2T2 > iOn2 ? 1 : 0) != 0);
            int i2 = s.indexOf("=", iJoin);
            Assert.assertTrue((String)s, (iArtistId2T2 > i2 || iArtistId2 > i2 ? 1 : 0) != 0);
            int iWhere = s.indexOf(" WHERE ");
            Assert.assertTrue((String)s, (iWhere > iJoin ? 1 : 0) != 0);
            int paintingTitle2 = s.indexOf(charStart + "t2" + charEnd + "." + charStart + "PAINTING_TITLE" + charEnd + " = ?");
            Assert.assertTrue((String)s, (paintingTitle2 > iWhere ? 1 : 0) != 0);
        }
        finally {
            DbEntity entity = this.context.getEntityResolver().getDbEntity("ARTIST");
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSqlStringWithQuoteSqlIdentifiers4() throws Exception {
        try {
            ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.joint());
            DbEntity entity = this.context.getEntityResolver().getDbEntity("PAINTING");
            entity.getDataMap().setQuotingSQLIdentifiers(true);
            String charStart = this.unitAdapter.getIdentifiersStartQuote();
            String charEnd = this.unitAdapter.getIdentifiersEndQuote();
            String s = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver()).getSql();
            Assert.assertTrue((String)s, (boolean)s.startsWith("SELECT "));
            int iFrom = s.indexOf(" FROM ");
            Assert.assertTrue((String)s, (iFrom > 0 ? 1 : 0) != 0);
            int paintingDescription = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "PAINTING_DESCRIPTION" + charEnd);
            Assert.assertTrue((String)s, (paintingDescription > 0 && paintingDescription < iFrom ? 1 : 0) != 0);
            int paintingTitle = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "PAINTING_TITLE" + charEnd);
            Assert.assertTrue((String)s, (paintingTitle > 0 && paintingTitle < iFrom ? 1 : 0) != 0);
            int artistIdT1 = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((String)s, (artistIdT1 > 0 && artistIdT1 < iFrom ? 1 : 0) != 0);
            int estimatedPrice = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ESTIMATED_PRICE" + charEnd);
            Assert.assertTrue((String)s, (estimatedPrice > 0 && estimatedPrice < iFrom ? 1 : 0) != 0);
            int galleryId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "GALLERY_ID" + charEnd);
            Assert.assertTrue((String)s, (galleryId > 0 && galleryId < iFrom ? 1 : 0) != 0);
            int paintingId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "PAINTING_ID" + charEnd);
            Assert.assertTrue((String)s, (paintingId > 0 && paintingId < iFrom ? 1 : 0) != 0);
            int artistName = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_NAME" + charEnd);
            Assert.assertTrue((String)s, (artistName > 0 && artistName < iFrom ? 1 : 0) != 0);
            int artistId = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_ID" + charEnd);
            Assert.assertTrue((String)s, (artistId > 0 && artistId < iFrom ? 1 : 0) != 0);
            int dateOfBirth = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "DATE_OF_BIRTH" + charEnd);
            Assert.assertTrue((String)s, (dateOfBirth > 0 && dateOfBirth < iFrom ? 1 : 0) != 0);
            int iPainting = s.indexOf(charStart + "PAINTING" + charEnd + " " + charStart + "t0" + charEnd);
            Assert.assertTrue((String)s, (iPainting > iFrom ? 1 : 0) != 0);
            int iLeftJoin = s.indexOf("LEFT JOIN");
            Assert.assertTrue((String)s, (iLeftJoin > iFrom ? 1 : 0) != 0);
            int iArtist = s.indexOf(charStart + "ARTIST" + charEnd + " " + charStart + "t1" + charEnd);
            Assert.assertTrue((String)s, (iArtist > iLeftJoin ? 1 : 0) != 0);
            int iOn = s.indexOf(" ON ");
            Assert.assertTrue((String)s, (iOn > iLeftJoin ? 1 : 0) != 0);
            int iArtistId = s.indexOf(charStart + "t0" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iLeftJoin);
            Assert.assertTrue((String)s, (iArtistId > iOn ? 1 : 0) != 0);
            int iArtistIdT1 = s.indexOf(charStart + "t1" + charEnd + "." + charStart + "ARTIST_ID" + charEnd, iLeftJoin);
            Assert.assertTrue((String)s, (iArtistIdT1 > iOn ? 1 : 0) != 0);
            int i = s.indexOf("=", iLeftJoin);
            Assert.assertTrue((String)s, (iArtistIdT1 > i || iArtistId > i ? 1 : 0) != 0);
        }
        finally {
            DbEntity entity = this.context.getEntityResolver().getDbEntity("PAINTING");
            entity.getDataMap().setQuotingSQLIdentifiers(false);
        }
    }

    @Test
    public void testBuildResultColumns1() throws Exception {
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class);
        DefaultSelectTranslator tr = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        tr.getSql();
        List<ColumnDescriptor> columns = Arrays.asList(tr.getResultColumns());
        columns.sort(Comparator.comparing(ColumnDescriptor::getName));
        DbEntity entity = this.context.getEntityResolver().getDbEntity("PAINTING");
        ArrayList<DbAttribute> attributes = new ArrayList<DbAttribute>(entity.getAttributes());
        attributes.sort(Comparator.comparing(Attribute::getName));
        Assert.assertEquals((long)attributes.size(), (long)columns.size());
        for (int i = 0; i < attributes.size(); ++i) {
            DbAttribute attribute = (DbAttribute)attributes.get(i);
            ColumnDescriptor descriptor = columns.get(i);
            Assert.assertEquals((Object)attribute, (Object)descriptor.getAttribute());
            Assert.assertEquals((Object)attribute.getName(), (Object)descriptor.getName());
            Assert.assertEquals((Object)attribute.getName(), (Object)descriptor.getDataRowKey());
            Assert.assertEquals((long)attribute.getType(), (long)descriptor.getJdbcType());
        }
    }

    @Test
    public void testBuildResultColumns2() throws Exception {
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.joint());
        DefaultSelectTranslator tr = new DefaultSelectTranslator(q, this.dataNode.getAdapter(), this.dataNode.getEntityResolver());
        tr.getSql();
        List<ColumnDescriptor> columns = Arrays.asList(tr.getResultColumns());
        columns.sort(Comparator.comparing(ColumnDescriptor::getName));
        DbEntity rootEntity = this.context.getEntityResolver().getDbEntity("PAINTING");
        ArrayList<DbAttribute> attributes = new ArrayList<DbAttribute>(rootEntity.getAttributes());
        DbEntity joinedEntity = this.context.getEntityResolver().getDbEntity("ARTIST");
        attributes.addAll(joinedEntity.getAttributes());
        attributes.sort(Comparator.comparing(Attribute::getName));
        for (int i = 0; i < attributes.size(); ++i) {
            DbAttribute attribute = (DbAttribute)attributes.get(i);
            ColumnDescriptor descriptor = columns.get(i);
            Assert.assertEquals((Object)attribute, (Object)descriptor.getAttribute());
            Assert.assertEquals((Object)attribute.getName(), (Object)descriptor.getName());
            if ("ARTIST".equals(attribute.getEntity().getName())) {
                Assert.assertEquals((Object)("toArtist." + attribute.getName()), (Object)descriptor.getDataRowKey());
            } else {
                Assert.assertEquals((Object)attribute.getName(), (Object)descriptor.getDataRowKey());
            }
            Assert.assertEquals((long)attribute.getType(), (long)descriptor.getJdbcType());
        }
    }
}

