/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import org.apache.cayenne.access.sqlbuilder.InsertBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationVisitor;
import org.apache.cayenne.access.sqlbuilder.StringBuilderAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.InsertNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class InsertBuilderTest {
    @Test
    public void testInsert() {
        InsertBuilder builder = new InsertBuilder("test");
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(InsertNode.class));
        this.assertSQL("INSERT INTO test", node);
    }

    @Test
    public void testInsertWithColumns() {
        InsertBuilder builder = new InsertBuilder("test");
        builder.column(SQLBuilder.column("col1")).column(SQLBuilder.column("col2")).column(SQLBuilder.column("col3"));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(InsertNode.class));
        this.assertSQL("INSERT INTO test( col1, col2, col3)", node);
    }

    @Test
    public void testInsertWithValues() {
        InsertBuilder builder = new InsertBuilder("test");
        builder.value(SQLBuilder.value(1)).value(SQLBuilder.value("test")).value(SQLBuilder.value(null));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(InsertNode.class));
        this.assertSQL("INSERT INTO test VALUES( 1, 'test', NULL)", node);
    }

    @Test
    public void testInsertWithColumnsAndValues() {
        InsertBuilder builder = new InsertBuilder("test");
        builder.column(SQLBuilder.column("col1")).value(SQLBuilder.value(1)).column(SQLBuilder.column("col2")).value(SQLBuilder.value("test")).column(SQLBuilder.column("col3")).value(SQLBuilder.value(null));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(InsertNode.class));
        this.assertSQL("INSERT INTO test( col1, col2, col3) VALUES( 1, 'test', NULL)", node);
    }

    private void assertSQL(String expected, Node node) {
        SQLGenerationVisitor visitor = new SQLGenerationVisitor(new StringBuilderAppendable());
        node.visit(visitor);
        Assert.assertEquals((Object)expected, (Object)visitor.getSQLString());
    }
}

