/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import org.apache.cayenne.access.sqlbuilder.DeleteBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationVisitor;
import org.apache.cayenne.access.sqlbuilder.StringBuilderAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.DeleteNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DeleteBuilderTest {
    @Test
    public void testDelete() {
        DeleteBuilder builder = new DeleteBuilder("test");
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(DeleteNode.class));
        this.assertSQL("DELETE FROM test", node);
    }

    @Test
    public void testDeleteWithQualifier() {
        DeleteBuilder builder = new DeleteBuilder("test");
        Node node = builder.where(SQLBuilder.column("col1").eq(SQLBuilder.value(1)).and(SQLBuilder.column("col2").eq(SQLBuilder.value("test"))).and(SQLBuilder.column("col3").eq(SQLBuilder.value(null)))).build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(DeleteNode.class));
        this.assertSQL("DELETE FROM test WHERE ( ( col1 = 1 ) AND ( col2 = 'test' ) ) AND ( col3 IS NULL )", node);
    }

    private void assertSQL(String expected, Node node) {
        SQLGenerationVisitor visitor = new SQLGenerationVisitor(new StringBuilderAppendable());
        node.visit(visitor);
        Assert.assertEquals((Object)expected, (Object)visitor.getSQLString());
    }
}

