/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.lob.ClobTestEntity;
import org.apache.cayenne.testdo.lob.ClobTestRelation;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCaseContextsSync;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-lob.xml")
public class SelectActionIT
extends ServerCaseContextsSync {
    @Inject
    private DataContext context;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    @Test
    public void testFetchLimit_DistinctResultIterator() {
        if (this.accessStackAdapter.supportsLobs()) {
            this.insertClobDb();
            List resultRows = ObjectSelect.query(ClobTestEntity.class).where(ClobTestEntity.CLOB_VALUE.dot(ClobTestRelation.VALUE).eq(100)).limit(25).select(this.context);
            Assert.assertNotNull(resultRows);
            Assert.assertEquals((long)25L, (long)resultRows.size());
        }
    }

    @Test
    public void testColumnSelect_DistinctResultIterator() {
        if (this.accessStackAdapter.supportsLobs()) {
            this.insertClobDb();
            List result = ObjectSelect.query(ClobTestEntity.class).column(ClobTestEntity.CLOB_COL).where(ClobTestEntity.CLOB_VALUE.dot(ClobTestRelation.VALUE).eq(100)).select(this.context);
            Assert.assertEquals((long)21L, (long)result.size());
        }
    }

    protected void insertClobDb() {
        for (int i = 0; i < 80; ++i) {
            ClobTestEntity obj;
            if (i < 20) {
                obj = (ClobTestEntity)this.context.newObject("ClobTestEntity");
                obj.setClobCol("a1" + i);
                this.insertClobRel(obj);
                continue;
            }
            obj = (ClobTestEntity)this.context.newObject("ClobTestEntity");
            obj.setClobCol("a2");
            this.insertClobRel(obj);
        }
        this.context.commitChanges();
    }

    protected void insertClobRel(ClobTestEntity clobId) {
        for (int i = 0; i < 20; ++i) {
            ClobTestRelation obj = (ClobTestRelation)this.context.newObject("ClobTestRelation");
            obj.setValue(100);
            obj.setClobId(clobId);
        }
    }
}

