/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.MappedSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.date_time.CalendarEntity;
import org.apache.cayenne.testdo.date_time.DateTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-date-time.xml")
public class DateTimeTypesIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testCalendar() throws Exception {
        CalendarEntity test = this.context.newObject(CalendarEntity.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2002, 1, 1);
        test.setCalendarField(cal);
        this.context.commitChanges();
        CalendarEntity testRead = ObjectSelect.query(CalendarEntity.class).selectFirst(this.context);
        Assert.assertNotNull((Object)testRead.getCalendarField());
        Assert.assertEquals((Object)cal, (Object)testRead.getCalendarField());
        test.setCalendarField(null);
        this.context.commitChanges();
    }

    @Test
    public void testDate() throws Exception {
        DateTestEntity test = this.context.newObject(DateTestEntity.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2002, 1, 1);
        Date nowDate = cal.getTime();
        test.setDateColumn(nowDate);
        this.context.commitChanges();
        DateTestEntity testRead = ObjectSelect.query(DateTestEntity.class).selectFirst(this.context);
        Assert.assertNotNull((Object)testRead.getDateColumn());
        Assert.assertEquals((Object)nowDate, (Object)testRead.getDateColumn());
        Assert.assertEquals(Date.class, testRead.getDateColumn().getClass());
    }

    @Test
    public void testTime() throws Exception {
        DateTestEntity test = this.context.newObject(DateTestEntity.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1970, 0, 1, 1, 20, 30);
        Date nowTime = cal.getTime();
        test.setTimeColumn(nowTime);
        this.context.commitChanges();
        DateTestEntity testRead = ObjectSelect.query(DateTestEntity.class).selectFirst(this.context);
        Assert.assertNotNull((Object)testRead.getTimeColumn());
        Assert.assertEquals(Date.class, testRead.getTimeColumn().getClass());
        long delta = nowTime.getTime() - testRead.getTimeColumn().getTime();
        Assert.assertTrue((String)("" + delta), (Math.abs(delta) <= 3600000L ? 1 : 0) != 0);
    }

    @Test
    public void testTimestamp() throws Exception {
        DateTestEntity test = this.context.newObject(DateTestEntity.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2003, 1, 1, 1, 20, 30);
        Date now = cal.getTime();
        test.setTimestampColumn(now);
        this.context.commitChanges();
        DateTestEntity testRead = ObjectSelect.query(DateTestEntity.class).selectFirst(this.context);
        Assert.assertNotNull((Object)testRead.getTimestampColumn());
        Assert.assertEquals((Object)now, (Object)testRead.getTimestampColumn());
    }

    @Test
    public void testSQLTemplateTimestamp() throws Exception {
        DateTestEntity test = this.context.newObject(DateTestEntity.class);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2003, 1, 1, 1, 20, 30);
        Date now = cal.getTime();
        test.setTimestampColumn(now);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectDateTest")).get(0);
        Date columnValue = (Date)testRead.get("TIMESTAMP_COLUMN");
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals((Object)now, (Object)columnValue);
    }

    @Test
    public void testSQLTemplateDate() throws Exception {
        DateTestEntity test = (DateTestEntity)this.context.newObject("DateTestEntity");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2003, 1, 1, 1, 20, 30);
        java.sql.Date now = new java.sql.Date(cal.getTime().getTime());
        test.setDateColumn(now);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectDateTest")).get(0);
        Date columnValue = (Date)testRead.get("DATE_COLUMN");
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals((Object)now.toString(), (Object)new java.sql.Date(columnValue.getTime()).toString());
    }

    @Test
    public void testSQLTemplateTime() throws Exception {
        DateTestEntity test = (DateTestEntity)this.context.newObject("DateTestEntity");
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2003, 1, 1, 1, 20, 30);
        Time now = new Time(cal.getTime().getTime());
        test.setTimeColumn(now);
        this.context.commitChanges();
        DataRow testRead = (DataRow)this.context.performQuery(MappedSelect.query("SelectDateTest")).get(0);
        Date columnValue = (Date)testRead.get("TIME_COLUMN");
        Assert.assertNotNull((String)testRead.toString(), (Object)columnValue);
        Assert.assertNotNull((Object)columnValue);
        Assert.assertEquals((Object)now.toString(), (Object)new Time(columnValue.getTime()).toString());
    }
}

