/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.MockCallingBackListener;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataDomainCallbacksIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;
    @Inject
    private ObjectContext context;
    @Inject
    private ObjectContext context1;

    @Test
    public void testPostLoad() throws Exception {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        registry.addCallback(LifecycleEvent.POST_LOAD, Artist.class, "postLoadCallback");
        MockCallingBackListener listener = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_LOAD, Artist.class, listener, "publicCallback");
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        Assert.assertEquals((long)0L, (long)a1.getPostLoaded());
        Assert.assertNull((Object)listener.getPublicCalledbackEntity());
        ObjectSelect.query(Artist.class).select(this.context);
        Assert.assertEquals((long)1L, (long)a1.getPostLoaded());
        Assert.assertSame((Object)a1, (Object)listener.getPublicCalledbackEntity());
        a1.resetCallbackFlags();
        listener.reset();
        a1.resetCallbackFlags();
        listener.reset();
        this.context.rollbackChanges();
        Assert.assertEquals((long)0L, (long)a1.getPostLoaded());
        Assert.assertNull((Object)listener.getPublicCalledbackEntity());
        a1.setArtistName("YY");
        this.context.rollbackChanges();
        Assert.assertEquals((long)1L, (long)a1.getPostLoaded());
        Assert.assertSame((Object)a1, (Object)listener.getPublicCalledbackEntity());
        a1.resetCallbackFlags();
        listener.reset();
        Assert.assertEquals((long)0L, (long)a1.getPostLoaded());
        Assert.assertNull((Object)listener.getPublicCalledbackEntity());
        this.context.performQuery(new RefreshQuery(a1));
        Assert.assertEquals((long)0L, (long)a1.getPostLoaded());
        Assert.assertNull((Object)listener.getPublicCalledbackEntity());
        a1.getArtistName();
        Assert.assertEquals((long)1L, (long)a1.getPostLoaded());
        Assert.assertSame((Object)a1, (Object)listener.getPublicCalledbackEntity());
    }

    @Test
    public void testPostLoad_MixedResult() throws Exception {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        registry.addCallback(LifecycleEvent.POST_LOAD, Artist.class, "postLoadCallback");
        MockCallingBackListener listener = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_LOAD, Artist.class, listener, "publicCallback");
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        Assert.assertEquals((long)0L, (long)a1.getPostLoaded());
        Assert.assertNull((Object)listener.getPublicCalledbackEntity());
        EJBQLQuery q = new EJBQLQuery("select a, a.artistName from Artist a");
        this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)a1.getPostLoaded());
        Assert.assertSame((Object)a1, (Object)listener.getPublicCalledbackEntity());
    }

    @Test
    public void testPostLoad_Relationship() throws Exception {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        registry.addCallback(LifecycleEvent.POST_LOAD, Artist.class, "postLoadCallback");
        MockCallingBackListener listener = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_LOAD, Artist.class, listener, "publicCallback");
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setToArtist(a1);
        p1.setPaintingTitle("XXX");
        this.context.commitChanges();
        this.context.invalidateObjects(a1, p1);
        p1 = (Painting)ObjectSelect.query(Painting.class).select(this.context).get(0);
        a1 = p1.getToArtist();
        Assert.assertEquals((long)5L, (long)a1.getPersistenceState());
        Assert.assertEquals((long)0L, (long)a1.getPostLoaded());
        Assert.assertNull((Object)listener.getPublicCalledbackEntity());
        a1.getArtistName();
        Assert.assertEquals((long)1L, (long)a1.getPostLoaded());
        Assert.assertSame((Object)a1, (Object)listener.getPublicCalledbackEntity());
    }

    @Test
    public void testPostLoad_Prefetch() throws Exception {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        registry.addCallback(LifecycleEvent.POST_LOAD, Artist.class, "postLoadCallback");
        MockCallingBackListener listener = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_LOAD, Artist.class, listener, "publicCallback");
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setToArtist(a1);
        p1.setPaintingTitle("XXX");
        this.context.commitChanges();
        p1 = (Painting)ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint()).select(this.context).get(0);
        a1 = p1.getToArtist();
        Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
        Assert.assertEquals((long)1L, (long)a1.getPostLoaded());
        Assert.assertSame((Object)a1, (Object)listener.getPublicCalledbackEntity());
    }

    @Test
    public void testPostLoad_LocalObject() throws Exception {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        registry.addCallback(LifecycleEvent.POST_LOAD, Artist.class, "postLoadCallback");
        MockCallingBackListener listener = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_LOAD, Artist.class, listener, "publicCallback");
        Artist a2 = this.context1.localObject(a1);
        Assert.assertEquals((long)5L, (long)a2.getPersistenceState());
        Assert.assertEquals((long)0L, (long)a2.getPostLoaded());
        Assert.assertNull((Object)listener.getPublicCalledbackEntity());
        a2.getArtistName();
        Assert.assertEquals((long)1L, (long)a2.getPostLoaded());
        Assert.assertSame((Object)a2, (Object)listener.getPublicCalledbackEntity());
    }

    @Test
    public void testPostLoad_ThatModifiesObject() {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        registry.addCallback(LifecycleEvent.POST_LOAD, Artist.class, "postLoadCallback");
        MockCallingBackListener listener = new MockCallingBackListener(){

            @Override
            public void publicCallback(Object entity) {
                super.publicCallback(entity);
                Artist a = (Artist)entity;
                a.setArtistName("Changed");
            }
        };
        registry.addListener(LifecycleEvent.POST_LOAD, Artist.class, listener, "publicCallback");
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setToArtist(a1);
        p1.setPaintingTitle("XXX");
        this.context.commitChanges();
        this.context.invalidateObjects(a1, p1);
        p1 = (Painting)ObjectSelect.query(Painting.class).select(this.context1).get(0);
        a1 = p1.getToArtist();
        Assert.assertEquals((long)5L, (long)a1.getPersistenceState());
        Assert.assertEquals((long)0L, (long)a1.getPostLoaded());
        Assert.assertNull((Object)listener.getPublicCalledbackEntity());
        a1.getArtistName();
        Assert.assertTrue((a1.getPostLoaded() > 0 ? 1 : 0) != 0);
        Assert.assertSame((Object)a1, (Object)listener.getPublicCalledbackEntity());
    }

    @Test
    public void testPreUpdate() {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isPreUpdated());
        a1.setArtistName("YY");
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isPreUpdated());
        registry.addCallback(LifecycleEvent.PRE_UPDATE, Artist.class, "preUpdateCallback");
        a1.setArtistName("ZZ");
        this.context.commitChanges();
        Assert.assertTrue((boolean)a1.isPreUpdated());
        a1.resetCallbackFlags();
        Assert.assertFalse((boolean)a1.isPreUpdated());
        MockCallingBackListener listener2 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.PRE_UPDATE, Artist.class, listener2, "publicCallback");
        a1.setArtistName("AA");
        this.context.commitChanges();
        Assert.assertTrue((boolean)a1.isPreUpdated());
        Assert.assertSame((Object)a1, (Object)listener2.getPublicCalledbackEntity());
    }

    @Test
    public void testPostUpdate() {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isPostUpdated());
        a1.setArtistName("YY");
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isPostUpdated());
        registry.addCallback(LifecycleEvent.POST_UPDATE, Artist.class, "postUpdateCallback");
        a1.setArtistName("ZZ");
        this.context.commitChanges();
        Assert.assertTrue((boolean)a1.isPostUpdated());
        a1.resetCallbackFlags();
        Assert.assertFalse((boolean)a1.isPostUpdated());
        MockCallingBackListener listener2 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_UPDATE, Artist.class, listener2, "publicCallback");
        a1.setArtistName("AA");
        this.context.commitChanges();
        Assert.assertTrue((boolean)a1.isPostUpdated());
        Assert.assertSame((Object)a1, (Object)listener2.getPublicCalledbackEntity());
    }

    @Test
    public void testPostRemove() {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        registry.addCallback(LifecycleEvent.POST_REMOVE, Artist.class, "postRemoveCallback");
        MockCallingBackListener listener2 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_REMOVE, Artist.class, listener2, "publicCallback");
        this.context.deleteObjects(a1);
        this.context.commitChanges();
        Assert.assertTrue((boolean)a1.isPostRemoved());
        Assert.assertSame((Object)a1, (Object)listener2.getPublicCalledbackEntity());
    }

    @Test
    public void testPostRemove_UpdatedDeleted() {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        MockCallingBackListener listener1 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_REMOVE, Artist.class, listener1, "publicCallback");
        MockCallingBackListener listener2 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_UPDATE, Artist.class, listener2, "publicCallback");
        a1.setArtistName("YY");
        this.context.deleteObjects(a1);
        this.context.commitChanges();
        Assert.assertNull((Object)listener2.getPublicCalledbackEntity());
        Assert.assertSame((Object)a1, (Object)listener1.getPublicCalledbackEntity());
    }

    @Test
    public void testPostRemove_InsertedUpdatedDeleted() {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        MockCallingBackListener listener0 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_PERSIST, Artist.class, listener0, "publicCallback");
        MockCallingBackListener listener1 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_REMOVE, Artist.class, listener1, "publicCallback");
        MockCallingBackListener listener2 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_UPDATE, Artist.class, listener2, "publicCallback");
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.deleteObjects(a1);
        this.context.commitChanges();
        Assert.assertNull((Object)listener0.getPublicCalledbackEntity());
        Assert.assertNull((Object)listener1.getPublicCalledbackEntity());
        Assert.assertNull((Object)listener2.getPublicCalledbackEntity());
    }

    @Test
    public void testPostPersist() {
        LifecycleCallbackRegistry registry = this.resolver.getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isPostPersisted());
        registry.addCallback(LifecycleEvent.POST_PERSIST, Artist.class, "postPersistCallback");
        MockCallingBackListener listener2 = new MockCallingBackListener(){

            @Override
            public void publicCallback(Object entity) {
                super.publicCallback(entity);
                Assert.assertFalse((boolean)((Persistent)entity).getObjectId().isTemporary());
            }
        };
        registry.addListener(LifecycleEvent.POST_PERSIST, Artist.class, listener2, "publicCallback");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("XX");
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isPostPersisted());
        Assert.assertTrue((boolean)a2.isPostPersisted());
        Assert.assertSame((Object)a2, (Object)listener2.getPublicCalledbackEntity());
    }
}

