/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class ObjectIdTest {
    @Test
    public void testConstructor() {
        ObjectId temp1 = ObjectId.of("e");
        Assert.assertEquals((Object)"e", (Object)temp1.getEntityName());
        Assert.assertTrue((boolean)temp1.isTemporary());
        Assert.assertNotNull((Object)temp1.getKey());
        byte[] key = new byte[]{1, 2, 3};
        ObjectId temp2 = ObjectId.of("e1", key);
        Assert.assertEquals((Object)"e1", (Object)temp2.getEntityName());
        Assert.assertTrue((boolean)temp2.isTemporary());
        Assert.assertSame((Object)key, (Object)temp2.getKey());
    }

    @Test
    public void testSerializabilityTemp() throws Exception {
        ObjectId temp1 = ObjectId.of("e");
        ObjectId temp2 = Util.cloneViaSerialization(temp1);
        Assert.assertTrue((boolean)temp1.isTemporary());
        Assert.assertNotSame((Object)temp1, (Object)temp2);
        Assert.assertEquals((Object)temp1, (Object)temp2);
    }

    @Test
    public void testSerializabilityPerm() throws Exception {
        ObjectId perm1 = ObjectId.of("e", "a", "b");
        int h = perm1.hashCode();
        Assert.assertEquals((long)h, (long)perm1.hashCode());
        Assert.assertTrue((perm1.hashCode() != 0 ? 1 : 0) != 0);
        ObjectId perm2 = Util.cloneViaSerialization(perm1);
        Assert.assertEquals((long)h, (long)perm1.hashCode());
        Assert.assertFalse((boolean)perm2.isTemporary());
        Assert.assertNotSame((Object)perm1, (Object)perm2);
        Assert.assertEquals((Object)perm1, (Object)perm2);
    }

    @Test
    public void testEqualsTmoKey() {
        ObjectId oid1 = ObjectId.of("TE");
        Assert.assertEquals((Object)oid1, (Object)oid1);
        Assert.assertEquals((long)oid1.hashCode(), (long)oid1.hashCode());
    }

    @Test
    public void testEqualsSingleValueKeyStr() {
        ObjectId oid1 = ObjectId.of("T", "a", "b");
        ObjectId oid2 = ObjectId.of("T", "a", "b");
        Assert.assertEquals((Object)oid1, (Object)oid2);
        Assert.assertEquals((long)oid1.hashCode(), (long)oid2.hashCode());
    }

    @Test
    public void testNotEqualsSingleValueKeyStr() {
        ObjectId oid1 = ObjectId.of("T", "a", "a");
        ObjectId oid2 = ObjectId.of("T", "a", "b");
        Assert.assertNotEquals((Object)oid1, (Object)oid2);
        Assert.assertNotEquals((long)oid1.hashCode(), (long)oid2.hashCode());
    }

    @Test
    public void testEqualsSingleValueKeyNumeric() {
        ObjectId oid1 = ObjectId.of("T", "a", 42);
        ObjectId oid2 = ObjectId.of("T", "a", BigDecimal.valueOf(42L));
        Assert.assertEquals((Object)oid1, (Object)oid2);
        Assert.assertEquals((long)oid1.hashCode(), (long)oid2.hashCode());
    }

    @Test
    public void testNotEqualsSingleValueKeyNumeric() {
        ObjectId oid1 = ObjectId.of("T", "a", 41);
        ObjectId oid2 = ObjectId.of("T", "a", BigDecimal.valueOf(42L));
        Assert.assertNotEquals((Object)oid1, (Object)oid2);
        Assert.assertNotEquals((long)oid1.hashCode(), (long)oid2.hashCode());
    }

    @Test
    public void testEqualsCompoundKeyNoValues() {
        HashMap hm = new HashMap();
        ObjectId oid1 = ObjectId.of("T", hm);
        ObjectId oid2 = ObjectId.of("T", hm);
        Assert.assertEquals((Object)oid1, (Object)oid2);
        Assert.assertEquals((long)oid1.hashCode(), (long)oid2.hashCode());
    }

    @Test
    public void testEqualsSingleKeyFromMap() {
        String pknm = "xyzabc";
        HashMap<String, String> hm1 = new HashMap<String, String>();
        hm1.put(pknm, "123");
        HashMap<String, String> hm2 = new HashMap<String, String>();
        hm2.put(pknm, "123");
        ObjectId oid1 = ObjectId.of("T", hm1);
        ObjectId oid2 = ObjectId.of("T", hm2);
        Assert.assertEquals((Object)oid1, (Object)oid2);
        Assert.assertEquals((long)oid1.hashCode(), (long)oid2.hashCode());
    }

    @Test
    public void testNotEqualsCompoundKey() {
        HashMap<String, Integer> hm1 = new HashMap<String, Integer>();
        hm1.put("key1", 1);
        hm1.put("key2", 11);
        HashMap<String, Integer> hm2 = new HashMap<String, Integer>();
        hm2.put("key1", 11);
        hm2.put("key2", 1);
        ObjectId ref = ObjectId.of("T", hm1);
        ObjectId oid = ObjectId.of("T", hm2);
        Assert.assertNotEquals((Object)ref, (Object)oid);
    }

    @Test
    public void testEqualsCompoundKey1() {
        HashMap<String, Integer> hm1 = new HashMap<String, Integer>();
        hm1.put("key1", 1);
        hm1.put("key2", 2);
        HashMap<String, Integer> hm2 = new HashMap<String, Integer>();
        hm2.put("key1", 1);
        hm2.put("key2", 2);
        ObjectId ref = ObjectId.of("T", hm1);
        ObjectId oid = ObjectId.of("T", hm2);
        Assert.assertEquals((Object)ref, (Object)oid);
        Assert.assertEquals((long)ref.hashCode(), (long)oid.hashCode());
    }

    @Test
    public void testEqualsCompoundKey2() {
        LinkedHashMap<String, Integer> hm1 = new LinkedHashMap<String, Integer>();
        hm1.put("KEY1", 1);
        hm1.put("KEY2", 2);
        LinkedHashMap<String, Integer> hm2 = new LinkedHashMap<String, Integer>();
        hm2.put("KEY2", 2);
        hm2.put("KEY1", 1);
        ObjectId ref = ObjectId.of("T", hm1);
        ObjectId oid = ObjectId.of("T", hm2);
        Assert.assertEquals((Object)ref, (Object)oid);
        Assert.assertEquals((long)ref.hashCode(), (long)oid.hashCode());
    }

    @Test
    public void testEqualsCompoundKey3() {
        LinkedHashMap<String, Integer> hm1 = new LinkedHashMap<String, Integer>();
        hm1.put("KEY1", 1);
        hm1.put("KEY2", 2);
        LinkedHashMap<String, Number> hm2 = new LinkedHashMap<String, Number>();
        hm2.put("KEY2", new BigDecimal(2.0));
        hm2.put("KEY1", 1L);
        ObjectId ref = ObjectId.of("T", hm1);
        ObjectId oid = ObjectId.of("T", hm2);
        Assert.assertEquals((Object)ref, (Object)oid);
        Assert.assertEquals((long)ref.hashCode(), (long)oid.hashCode());
    }

    @Test
    public void testEqualsBinaryKey() {
        HashMap<String, byte[]> hm1 = new HashMap<String, byte[]>();
        hm1.put("key1", new byte[]{3, 4, 10, -1});
        HashMap<String, byte[]> hm2 = new HashMap<String, byte[]>();
        hm2.put("key1", new byte[]{3, 4, 10, -1});
        ObjectId ref = ObjectId.of("T", hm1);
        ObjectId oid = ObjectId.of("T", hm2);
        Assert.assertEquals((long)ref.hashCode(), (long)oid.hashCode());
        Assert.assertEquals((Object)ref, (Object)oid);
    }

    @Test
    public void testEqualsNull() {
        ObjectId o = ObjectId.of("T", "ARTIST_ID", 42);
        Assert.assertNotNull((Object)o);
    }

    @Test
    public void testIdAsMapKey() {
        HashMap<ObjectId, Object> map = new HashMap<ObjectId, Object>();
        Object o1 = new Object();
        String pknm = "xyzabc";
        HashMap<String, String> hm1 = new HashMap<String, String>();
        hm1.put(pknm, "123");
        HashMap<String, String> hm2 = new HashMap<String, String>();
        hm2.put(pknm, "123");
        ObjectId oid1 = ObjectId.of("T", hm1);
        ObjectId oid2 = ObjectId.of("T", hm2);
        map.put(oid1, o1);
        Assert.assertSame((Object)o1, map.get(oid2));
    }

    @Test
    public void testNotEqualTmpKey() {
        ObjectId oid1 = ObjectId.of("T1");
        ObjectId oid2 = ObjectId.of("T2");
        Assert.assertNotEquals((Object)oid1, (Object)oid2);
    }

    @Test
    public void testNotEqualSingleValueKey() {
        HashMap<String, String> hm1 = new HashMap<String, String>();
        hm1.put("pk1", "123");
        HashMap<String, String> hm2 = new HashMap<String, String>();
        hm2.put("pk1", "124");
        ObjectId oid1 = ObjectId.of("T", hm1);
        ObjectId oid2 = ObjectId.of("T", hm2);
        Assert.assertNotEquals((Object)oid1, (Object)oid2);
    }

    @Test
    public void testEquals8() {
        LinkedHashMap<String, Integer> hm1 = new LinkedHashMap<String, Integer>();
        hm1.put("KEY1", 1);
        hm1.put("KEY2", 2);
        LinkedHashMap<String, Number> hm2 = new LinkedHashMap<String, Number>();
        hm2.put("KEY2", new BigDecimal(2.0));
        hm2.put("KEY1", 1L);
        ObjectId ref = ObjectId.of("T", hm1);
        ObjectId oid = ObjectId.of("T", hm2);
        Assert.assertEquals((Object)ref, (Object)oid);
        Assert.assertEquals((long)ref.hashCode(), (long)oid.hashCode());
    }

    @Test
    public void testToString() {
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put("a", "1");
        m1.put("b", "2");
        ObjectId i1 = ObjectId.of("e1", m1);
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("b", "2");
        m2.put("a", "1");
        ObjectId i2 = ObjectId.of("e1", m2);
        Assert.assertEquals((Object)i1, (Object)i2);
        Assert.assertEquals((Object)i1.toString(), (Object)i2.toString());
    }
}

