/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships_flattened.Entity1;
import org.apache.cayenne.testdo.relationships_flattened.Entity3;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedCircular;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest1;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest2;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest3;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest4;
import org.apache.cayenne.testdo.relationships_flattened.FlattenedTest5;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-flattened.xml")
public class FlattenedRelationshipsIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context1;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tFlattenedTest1;
    private TableHelper tFlattenedTest2;
    private TableHelper tFlattenedTest3;
    private TableHelper tComplexJoin;
    private TableHelper tFlattenedCircular;
    private TableHelper tFlattenedCircularJoin;

    @Before
    public void setUp() throws Exception {
        this.tFlattenedTest1 = new TableHelper(this.dbHelper, "FLATTENED_TEST_1");
        this.tFlattenedTest1.setColumns(new String[]{"FT1_ID", "NAME"});
        this.tFlattenedTest2 = new TableHelper(this.dbHelper, "FLATTENED_TEST_2");
        this.tFlattenedTest2.setColumns(new String[]{"FT2_ID", "FT1_ID", "NAME"});
        this.tFlattenedTest3 = new TableHelper(this.dbHelper, "FLATTENED_TEST_3");
        this.tFlattenedTest3.setColumns(new String[]{"FT3_ID", "FT2_ID", "NAME"});
        this.tComplexJoin = new TableHelper(this.dbHelper, "COMPLEX_JOIN");
        this.tComplexJoin.setColumns(new String[]{"PK", "FT1_FK", "FT3_FK", "EXTRA_COLUMN"});
        this.tFlattenedCircular = new TableHelper(this.dbHelper, "FLATTENED_CIRCULAR");
        this.tFlattenedCircular.setColumns(new String[]{"ID"});
        this.tFlattenedCircularJoin = new TableHelper(this.dbHelper, "FLATTENED_CIRCULAR_JOIN");
        this.tFlattenedCircularJoin.setColumns(new String[]{"SIDE1_ID", "SIDE2_ID"});
    }

    private void createFlattenedTestDataSet() throws Exception {
        this.tFlattenedTest1.insert(new Object[]{1, "ft1"});
        this.tFlattenedTest1.insert(new Object[]{2, "ft12"});
        this.tFlattenedTest2.insert(new Object[]{1, 1, "ft2"});
        this.tFlattenedTest3.insert(new Object[]{1, 1, "ft3"});
    }

    private void createFlattenedCircularDataSet() throws Exception {
        this.tFlattenedCircular.insert(new Object[]{1});
        this.tFlattenedCircular.insert(new Object[]{2});
        this.tFlattenedCircular.insert(new Object[]{3});
        this.tFlattenedCircularJoin.insert(new Object[]{1, 2});
        this.tFlattenedCircularJoin.insert(new Object[]{1, 3});
    }

    private void createCircularJoinDataSet() throws Exception {
        this.tFlattenedTest1.insert(new Object[]{2, "ft12"});
        this.tFlattenedTest3.insert(new Object[]{2, null, "ft3-a"});
        this.tFlattenedTest3.insert(new Object[]{3, null, "ft3-b"});
        this.tComplexJoin.insert(new Object[]{2000, 2, 2, "A"});
        this.tComplexJoin.insert(new Object[]{2001, 2, 3, "B"});
        this.tComplexJoin.insert(new Object[]{2002, 2, 3, "C"});
    }

    @Test
    public void testInsertJoinWithPK() {
        FlattenedTest1 obj01 = this.context.newObject(FlattenedTest1.class);
        FlattenedTest3 obj11 = this.context.newObject(FlattenedTest3.class);
        FlattenedTest3 obj12 = this.context.newObject(FlattenedTest3.class);
        obj01.setName("t01");
        obj11.setName("t11");
        obj12.setName("t12");
        obj01.addToFt3OverComplex(obj11);
        obj01.addToFt3OverComplex(obj12);
        this.context.commitChanges();
        int pk = Cayenne.intPKForObject(obj01);
        this.context.invalidateObjects(obj01, obj11, obj12);
        FlattenedTest1 fresh01 = Cayenne.objectForPK((ObjectContext)this.context1, FlattenedTest1.class, pk);
        Assert.assertEquals((Object)"t01", (Object)fresh01.getName());
        ValueHolder related = (ValueHolder)((Object)fresh01.getFt3OverComplex());
        Assert.assertTrue((boolean)related.isFault());
        Assert.assertEquals((long)2L, (long)((List)((Object)related)).size());
    }

    @Test
    public void testUnsetJoinWithPK() throws Exception {
        this.createCircularJoinDataSet();
        SQLTemplate joinSelect = new SQLTemplate(FlattenedTest1.class, "SELECT * FROM COMPLEX_JOIN");
        joinSelect.setFetchingDataRows(true);
        Assert.assertEquals((long)3L, (long)this.context.performQuery(joinSelect).size());
        FlattenedTest1 ft1 = Cayenne.objectForPK((ObjectContext)this.context, FlattenedTest1.class, 2);
        Assert.assertEquals((Object)"ft12", (Object)ft1.getName());
        List<FlattenedTest3> related = ft1.getFt3OverComplex();
        Assert.assertTrue((boolean)((ValueHolder)((Object)related)).isFault());
        Assert.assertEquals((long)2L, (long)related.size());
        FlattenedTest3 ft3 = Cayenne.objectForPK((ObjectContext)this.context, FlattenedTest3.class, 3);
        Assert.assertTrue((boolean)related.contains(ft3));
        ft1.removeFromFt3OverComplex(ft3);
        Assert.assertFalse((boolean)related.contains(ft3));
        this.context.commitChanges();
        Assert.assertEquals((long)1L, (long)this.context.performQuery(joinSelect).size());
    }

    @Test
    public void testQualifyOnToManyFlattened() {
        FlattenedTest1 obj01 = this.context.newObject(FlattenedTest1.class);
        FlattenedTest2 obj02 = this.context.newObject(FlattenedTest2.class);
        FlattenedTest3 obj031 = this.context.newObject(FlattenedTest3.class);
        FlattenedTest3 obj032 = this.context.newObject(FlattenedTest3.class);
        FlattenedTest1 obj11 = this.context.newObject(FlattenedTest1.class);
        FlattenedTest2 obj12 = this.context.newObject(FlattenedTest2.class);
        FlattenedTest3 obj131 = this.context.newObject(FlattenedTest3.class);
        obj01.setName("t01");
        obj02.setName("t02");
        obj031.setName("t031");
        obj032.setName("t032");
        obj02.setToFT1(obj01);
        obj02.addToFt3Array(obj031);
        obj02.addToFt3Array(obj032);
        obj11.setName("t11");
        obj131.setName("t131");
        obj12.setName("t12");
        obj12.addToFt3Array(obj131);
        obj12.setToFT1(obj11);
        this.context.commitChanges();
        List objects1 = ObjectSelect.query(FlattenedTest1.class).where(FlattenedTest1.FT3ARRAY.dot(FlattenedTest3.NAME).eq("t031")).select(this.context);
        Assert.assertEquals((long)1L, (long)objects1.size());
        Assert.assertSame((Object)obj01, objects1.get(0));
        List objects2 = ObjectSelect.query(FlattenedTest1.class).where(FlattenedTest1.FT3ARRAY.contains(obj131)).select(this.context);
        Assert.assertEquals((long)1L, (long)objects2.size());
        Assert.assertSame((Object)obj11, objects2.get(0));
    }

    @Test
    public void testToOneSeriesFlattenedRel() {
        FlattenedTest1 ft1 = (FlattenedTest1)this.context.newObject("FlattenedTest1");
        ft1.setName("FT1Name");
        FlattenedTest2 ft2 = (FlattenedTest2)this.context.newObject("FlattenedTest2");
        ft2.setName("FT2Name");
        FlattenedTest3 ft3 = (FlattenedTest3)this.context.newObject("FlattenedTest3");
        ft3.setName("FT3Name");
        ft2.setToFT1(ft1);
        ft2.addToFt3Array(ft3);
        this.context.commitChanges();
        this.context.invalidateObjects(ft1, ft2, ft3);
        List results = ObjectSelect.query(FlattenedTest3.class, FlattenedTest3.NAME.eq("FT3Name")).select(this.context);
        Assert.assertEquals((long)1L, (long)results.size());
        FlattenedTest3 fetchedFT3 = (FlattenedTest3)results.get(0);
        FlattenedTest1 fetchedFT1 = fetchedFT3.getToFT1();
        Assert.assertEquals((Object)"FT1Name", (Object)fetchedFT1.getName());
    }

    @Test
    public void testTakeObjectSnapshotFlattenedFault() throws Exception {
        this.createFlattenedTestDataSet();
        List ft3s = ObjectSelect.query(FlattenedTest3.class).select(this.context);
        Assert.assertEquals((long)1L, (long)ft3s.size());
        FlattenedTest3 ft3 = (FlattenedTest3)ft3s.get(0);
        Assert.assertTrue((boolean)(ft3.readPropertyDirectly("toFT1") instanceof Fault));
        DataRow snapshot = this.context.currentSnapshot(ft3);
        Assert.assertEquals((Object)"ft3", snapshot.get("NAME"));
        Assert.assertTrue((boolean)(ft3.readPropertyDirectly("toFT1") instanceof Fault));
    }

    @Test
    public void testRefetchWithFlattenedFaultToOneTarget1() throws Exception {
        this.createFlattenedTestDataSet();
        List ft3s = ObjectSelect.query(FlattenedTest3.class).select(this.context);
        Assert.assertEquals((long)1L, (long)ft3s.size());
        FlattenedTest3 ft3 = (FlattenedTest3)ft3s.get(0);
        Assert.assertTrue((boolean)(ft3.readPropertyDirectly("toFT1") instanceof Fault));
        ObjectSelect.query(FlattenedTest3.class).select(this.context);
        Assert.assertTrue((boolean)(ft3.readPropertyDirectly("toFT1") instanceof Fault));
    }

    @Test
    public void testFlattenedCircular() throws Exception {
        this.createFlattenedCircularDataSet();
        FlattenedCircular fc1 = Cayenne.objectForPK((ObjectContext)this.context, FlattenedCircular.class, 1);
        List<FlattenedCircular> side2s = fc1.getSide2s();
        Assert.assertEquals((long)2L, (long)side2s.size());
        List<FlattenedCircular> side1s = fc1.getSide1s();
        Assert.assertTrue((boolean)side1s.isEmpty());
    }

    @Test
    public void testFlattenedComplexToOneRelationship() {
        FlattenedTest1 ft1 = this.context.newObject(FlattenedTest1.class);
        ft1.setName("FT1");
        FlattenedTest5 ft5 = this.context.newObject(FlattenedTest5.class);
        ft5.setName("FT5");
        ft5.setToFT1(ft1);
        this.context.commitChanges();
        FlattenedTest5 ft5Persisted = ObjectSelect.query(FlattenedTest5.class).selectFirst(this.context);
        Assert.assertEquals((Object)ft1, (Object)ft5Persisted.getToFT1());
    }

    @Test
    public void testNullFlattenedComplexToOneRelationship() {
        FlattenedTest5 ft5 = this.context.newObject(FlattenedTest5.class);
        ft5.setName("FT5");
        ValidationResult validationResult = new ValidationResult();
        ft5.validateForSave(validationResult);
        Assert.assertTrue((String)validationResult.toString(), (boolean)validationResult.getFailures().isEmpty());
        this.context.commitChanges();
        Assert.assertEquals((long)1L, (long)ObjectSelect.query(FlattenedTest5.class).selectCount(this.context));
    }

    @Test
    public void testSetFlattenedRelationship() {
        FlattenedTest1 flattenedTest1 = this.context.newObject(FlattenedTest1.class);
        flattenedTest1.setName("f1");
        FlattenedTest3 flattenedTest3 = this.context.newObject(FlattenedTest3.class);
        flattenedTest3.setName("f3");
        flattenedTest3.setToFT1(flattenedTest1);
        this.context.commitChanges();
        List flattenedTest3s = ObjectSelect.query(FlattenedTest3.class).prefetch(FlattenedTest3.TO_FT1.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)flattenedTest3s.size());
        Assert.assertEquals((Object)"f3", (Object)((FlattenedTest3)flattenedTest3s.get(0)).getName());
        Assert.assertEquals((Object)"f1", (Object)((FlattenedTest3)flattenedTest3s.get(0)).getToFT1().getName());
    }

    @Test
    public void testSecondToOneReverseToFk() {
        FlattenedTest1 flattenedTest1 = this.context.newObject(FlattenedTest1.class);
        flattenedTest1.setName("f1");
        FlattenedTest4 flattenedTest4 = this.context.newObject(FlattenedTest4.class);
        flattenedTest4.setName("f4");
        flattenedTest1.addToFt4ArrayFor1(flattenedTest4);
        this.context.commitChanges();
    }

    @Test
    public void testSecondToOneToFk() {
        Entity1 entity1 = this.context.newObject(Entity1.class);
        Entity3 entity3 = this.context.newObject(Entity3.class);
        entity1.setToEntity3(entity3);
        this.context.commitChanges();
        List entity1s = ObjectSelect.query(Entity1.class).prefetch(Entity1.TO_ENTITY3.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)entity1s.size());
        Assert.assertNotNull((Object)((Entity1)entity1s.get(0)).getToEntity3());
    }

    @Test
    public void testSetFlattenedCircular() {
        FlattenedCircular flattenedCircular1 = this.context.newObject(FlattenedCircular.class);
        FlattenedCircular flattenedCircular2 = this.context.newObject(FlattenedCircular.class);
        flattenedCircular1.addToSide1s(flattenedCircular2);
        this.context.commitChanges();
        List flattenedCirculars = ObjectSelect.query(FlattenedCircular.class).prefetch(FlattenedCircular.SIDE1S.disjoint()).select(this.context);
        Assert.assertEquals((long)2L, (long)flattenedCirculars.size());
    }

    @Test
    public void testFt1ToFt5Flattened() {
        FlattenedTest1 flattenedTest1 = this.context.newObject(FlattenedTest1.class);
        flattenedTest1.setName("f1");
        FlattenedTest5 flattenedTest5 = this.context.newObject(FlattenedTest5.class);
        flattenedTest5.setName("f5");
        flattenedTest1.addToFt5Array(flattenedTest5);
        this.context.commitChanges();
        List flattenedTest1s = ObjectSelect.query(FlattenedTest1.class).prefetch(FlattenedTest1.FT5ARRAY.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)flattenedTest1s.size());
        Assert.assertEquals((long)1L, (long)((FlattenedTest1)flattenedTest1s.get(0)).getFt5Array().size());
    }

    @Test
    public void testFt5ToFt1Flattened() {
        FlattenedTest5 flattenedTest5 = this.context.newObject(FlattenedTest5.class);
        flattenedTest5.setName("f5");
        FlattenedTest1 flattenedTest1 = this.context.newObject(FlattenedTest1.class);
        flattenedTest1.setName("f1");
        flattenedTest5.setToFT1(flattenedTest1);
        this.context.commitChanges();
        List flattenedTest5s = ObjectSelect.query(FlattenedTest5.class).prefetch(FlattenedTest5.TO_FT1.disjoint()).select(this.context);
        Assert.assertEquals((long)1L, (long)flattenedTest5s.size());
        Assert.assertEquals((Object)"f5", (Object)((FlattenedTest5)flattenedTest5s.get(0)).getName());
        Assert.assertEquals((Object)"f1", (Object)((FlattenedTest5)flattenedTest5s.get(0)).getToFT1().getName());
    }
}

