/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.ROPainting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CDOMany2OneIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected TableHelper tGallery;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"}).setColumnTypes(new int[]{4, 12, -5, 4});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
    }

    private void createArtistWithPaintingDataSet() throws Exception {
        this.tArtist.insert(new Object[]{8, "aX"});
        this.tPainting.insert(new Object[]{6, "pW", 8, null});
    }

    private void createArtistWithPaintingsInGalleryDataSet() throws Exception {
        this.tArtist.insert(new Object[]{8, "aX"});
        this.tGallery.insert(new Object[]{11, "Ge"});
        this.tPainting.insert(new Object[]{6, "pW1", 8, 11});
        this.tPainting.insert(new Object[]{7, "pW2", 8, 11});
    }

    @Test
    public void testMultipleToOneDeletion() {
        Painting p = this.context.newObject(Painting.class);
        p.setPaintingTitle("P1");
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("A1");
        Gallery g = this.context.newObject(Gallery.class);
        g.setGalleryName("G1");
        p.setToArtist(a);
        p.setToGallery(g);
        this.context.commitChanges();
        p.setToArtist(null);
        p.setToGallery(null);
        this.context.commitChanges();
        SQLTemplate q = new SQLTemplate(Painting.class, "SELECT * from PAINTING");
        q.setColumnNamesCapitalization(CapsStrategy.UPPER);
        q.setFetchingDataRows(true);
        DataRow row = (DataRow)Cayenne.objectForQuery(this.context, q);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"P1", row.get("PAINTING_TITLE"));
        Assert.assertNull(row.get("ARTIST_ID"));
        Assert.assertNull(row.get("GALLERY_ID"));
    }

    @Test
    public void testReadRO1() throws Exception {
        this.createArtistWithPaintingDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 8);
        List paints = ObjectSelect.query(ROPainting.class, ROPainting.TO_ARTIST.eq(a1)).select(this.context);
        Assert.assertEquals((long)1L, (long)paints.size());
        ROPainting rop1 = (ROPainting)paints.get(0);
        Assert.assertSame((Object)a1, (Object)rop1.getToArtist());
    }

    @Test
    public void testReadRO2() throws Exception {
        this.createArtistWithPaintingDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 8);
        List paints = ObjectSelect.query(ROPainting.class, ROPainting.TO_ARTIST.eq(a1)).select(this.context);
        Assert.assertEquals((long)1L, (long)paints.size());
        ROPainting rop1 = (ROPainting)paints.get(0);
        Assert.assertNotNull((Object)rop1.getToArtist());
        rop1.getToArtist().getArtistName();
        Assert.assertEquals((long)3L, (long)rop1.getToArtist().getPersistenceState());
    }

    @Test
    public void testSelectViaRelationship() throws Exception {
        this.createArtistWithPaintingDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 8);
        Painting p1 = Cayenne.objectForPK(this.context, Painting.class, 6);
        List paints = ObjectSelect.query(Painting.class, Painting.TO_ARTIST.eq(a1)).select(this.context);
        Assert.assertEquals((long)1L, (long)paints.size());
        Assert.assertSame((Object)p1, paints.get(0));
    }

    @Test
    public void testSelectViaMultiRelationship() throws Exception {
        this.createArtistWithPaintingsInGalleryDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 8);
        Gallery g1 = Cayenne.objectForPK(this.context, Gallery.class, 11);
        List artists = ObjectSelect.query(Artist.class).where(Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY).eq(g1)).select(this.context);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertSame((Object)a1, artists.get(0));
    }

    @Test
    public void testNewAdd() throws Exception {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("bL");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("xa");
        p1.setToArtist(a1);
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertEquals((long)1L, (long)a1.getPaintingArray().size());
        Assert.assertSame((Object)p1, (Object)a1.getPaintingArray().get(0));
        this.context.commitChanges();
        Assert.assertEquals((long)Cayenne.longPKForObject(a1), (long)this.tArtist.getLong("ARTIST_ID"));
        Assert.assertEquals((long)Cayenne.longPKForObject(a1), (long)this.tPainting.getLong("ARTIST_ID"));
    }

    @Test
    public void testRemove() {
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("xa");
        Gallery g1 = this.context.newObject(Gallery.class);
        g1.setGalleryName("yT");
        p1.setToGallery(g1);
        this.context.commitChanges();
        ObjectContext context2 = this.runtime.newContext();
        Painting p2 = (Painting)ObjectSelect.query(Painting.class).selectOne(context2);
        Gallery g2 = p2.getToGallery();
        p2.setToGallery(null);
        Assert.assertEquals((long)0L, (long)g2.getPaintingArray().size());
        Assert.assertNull((Object)p2.getToGallery());
        context2.commitChanges();
        ObjectContext context3 = this.runtime.newContext();
        Painting p3 = (Painting)ObjectSelect.query(Painting.class).selectOne(context3);
        Assert.assertNull((Object)p3.getToGallery());
    }

    @Test
    public void testReplace() {
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("xa");
        Gallery g1 = this.context.newObject(Gallery.class);
        g1.setGalleryName("yTW");
        p1.setToGallery(g1);
        this.context.commitChanges();
        ObjectContext context2 = this.runtime.newContext();
        Painting p2 = (Painting)ObjectSelect.query(Painting.class).selectOne(context2);
        Gallery g21 = p2.getToGallery();
        Assert.assertNotNull((Object)g21);
        Assert.assertEquals((Object)"yTW", (Object)g21.getGalleryName());
        Assert.assertEquals((long)1L, (long)g21.getPaintingArray().size());
        Assert.assertSame((Object)p2, (Object)g21.getPaintingArray().get(0));
        Gallery g22 = context2.newObject(Gallery.class);
        g22.setGalleryName("rE");
        p2.setToGallery(g22);
        Assert.assertEquals((long)0L, (long)g21.getPaintingArray().size());
        Assert.assertEquals((long)1L, (long)g22.getPaintingArray().size());
        Assert.assertSame((Object)p2, (Object)g22.getPaintingArray().get(0));
        context2.commitChanges();
        ObjectContext context3 = this.runtime.newContext();
        Painting p3 = (Painting)ObjectSelect.query(Painting.class).selectOne(context3);
        Gallery g3 = p3.getToGallery();
        Assert.assertNotNull((Object)g3);
        Assert.assertEquals((Object)"rE", (Object)g3.getGalleryName());
        Assert.assertEquals((long)1L, (long)g3.getPaintingArray().size());
        Assert.assertSame((Object)p3, (Object)g3.getPaintingArray().get(0));
    }

    @Test
    public void testSavedAdd() {
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("xa");
        Assert.assertTrue((boolean)this.context.hasChanges());
        this.context.commitChanges();
        ObjectContext context2 = this.runtime.newContext();
        Painting p2 = (Painting)ObjectSelect.query(Painting.class).selectOne(context2);
        Assert.assertNull((Object)p2.getToGallery());
        Gallery g2 = context2.newObject(Gallery.class);
        g2.setGalleryName("rE");
        p2.setToGallery(g2);
        Assert.assertEquals((long)1L, (long)g2.getPaintingArray().size());
        Assert.assertSame((Object)p2, (Object)g2.getPaintingArray().get(0));
        context2.commitChanges();
        ObjectContext context3 = this.runtime.newContext();
        Painting p3 = (Painting)ObjectSelect.query(Painting.class).selectOne(context3);
        Gallery g3 = p3.getToGallery();
        Assert.assertNotNull((Object)g3);
        Assert.assertEquals((Object)"rE", (Object)g3.getGalleryName());
        Assert.assertEquals((long)1L, (long)g3.getPaintingArray().size());
        Assert.assertSame((Object)p3, (Object)g3.getPaintingArray().get(0));
    }
}

