/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTFunctionCall;

public class ASTExtract
extends ASTFunctionCall {
    private static final Map<String, DateTimePart> NAME_TO_PART = new HashMap<String, DateTimePart>();
    private String partName;
    private DateTimePart part;

    ASTExtract(int id) {
        super(id, "EXTRACT");
    }

    public ASTExtract(Expression expression) {
        super(53, "EXTRACT", expression);
    }

    @Override
    public String getFunctionName() {
        return this.part.name();
    }

    @Override
    protected void appendFunctionNameAsString(Appendable out) throws IOException {
        out.append(this.partName);
    }

    void setPartToken(String partToken) {
        this.part = NAME_TO_PART.get(partToken);
        if (this.part == null) {
            throw new CayenneRuntimeException("Unknown timestamp part: %s", partToken);
        }
        this.partName = partToken;
    }

    public void setPart(DateTimePart part) {
        this.part = part;
        this.partName = ASTExtract.nameToCamelCase(part.name());
    }

    public DateTimePart getPart() {
        return this.part;
    }

    public String getPartCamelCaseName() {
        return this.partName;
    }

    @Override
    public Expression shallowCopy() {
        ASTExtract copy = new ASTExtract(this.id);
        copy.partName = this.partName;
        copy.part = this.part;
        return copy;
    }

    @Override
    protected int getRequiredChildrenCount() {
        return 1;
    }

    @Override
    protected Object evaluateSubNode(Object o, Object[] evaluatedChildren) throws Exception {
        return null;
    }

    static {
        for (DateTimePart part : DateTimePart.values()) {
            NAME_TO_PART.put(ASTExtract.nameToCamelCase(part.name()), part);
        }
    }

    public static enum DateTimePart {
        YEAR,
        MONTH,
        WEEK,
        DAY_OF_YEAR,
        DAY,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        HOUR,
        MINUTE,
        SECOND;

    }
}

