/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.net.URL;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.translator.ejbql.JdbcEJBQLTranslatorFactory;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslator;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ValueObjectTypeFactory;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.DefaultQuotingStrategy;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesHandler;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.util.Util;

public class JdbcAdapter
implements DbAdapter {
    private PkGenerator pkGenerator;
    protected QuotingStrategy quotingStrategy;
    protected TypesHandler typesHandler;
    protected ExtendedTypeMap extendedTypes;
    protected boolean supportsBatchUpdates;
    protected boolean supportsUniqueConstraints;
    protected boolean supportsGeneratedKeys;
    protected EJBQLTranslatorFactory ejbqlTranslatorFactory;
    protected ResourceLocator resourceLocator;
    protected boolean caseInsensitiveCollations;
    @Inject
    protected BatchTranslatorFactory batchQueryBuilderFactory;
    @Inject
    protected JdbcEventLogger logger;

    public JdbcAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        this.setSupportsBatchUpdates(false);
        this.setSupportsUniqueConstraints(true);
        this.caseInsensitiveCollations = runtimeProperties.getBoolean("cayenne.runtime.db.collation.assume.ci", false);
        this.resourceLocator = resourceLocator;
        this.pkGenerator = this.createPkGenerator();
        this.quotingStrategy = this.createQuotingStrategy();
        this.ejbqlTranslatorFactory = this.createEJBQLTranslatorFactory();
        this.typesHandler = TypesHandler.getHandler(this.findResource("/types.xml"));
        this.extendedTypes = new ExtendedTypeMap();
        this.initExtendedTypes(defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, valueObjectTypeRegistry);
    }

    @Override
    public String getBatchTerminator() {
        return ";";
    }

    public JdbcEventLogger getJdbcEventLogger() {
        return this.logger;
    }

    protected URL findResource(String name) {
        for (Class<?> adapterClass = this.getClass(); adapterClass != null && JdbcAdapter.class.isAssignableFrom(adapterClass); adapterClass = adapterClass.getSuperclass()) {
            String path = Util.getPackagePath(adapterClass.getName()) + name;
            Collection<Resource> resources = this.resourceLocator.findResources(path);
            if (resources.isEmpty()) continue;
            return resources.iterator().next().getURL();
        }
        return null;
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
    }

    protected void initExtendedTypes(List<ExtendedType> defaultExtendedTypes, List<ExtendedType> userExtendedTypes, List<ExtendedTypeFactory> extendedTypeFactories, ValueObjectTypeRegistry valueObjectTypeRegistry) {
        for (ExtendedType type : defaultExtendedTypes) {
            this.extendedTypes.registerType(type);
        }
        this.configureExtendedTypes(this.extendedTypes);
        for (ExtendedType type : userExtendedTypes) {
            this.extendedTypes.registerType(type);
        }
        for (ExtendedTypeFactory typeFactory : extendedTypeFactories) {
            this.extendedTypes.addFactory(typeFactory);
        }
        this.extendedTypes.addFactory(new ValueObjectTypeFactory(this.extendedTypes, valueObjectTypeRegistry));
    }

    @Deprecated
    protected PkGenerator createPkGenerator() {
        return new JdbcPkGenerator(this);
    }

    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        JdbcEJBQLTranslatorFactory translatorFactory = new JdbcEJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public PkGenerator getPkGenerator() {
        return this.pkGenerator;
    }

    @Override
    public void setPkGenerator(PkGenerator pkGenerator) {
        this.pkGenerator = pkGenerator;
    }

    @Override
    public boolean supportsUniqueConstraints() {
        return this.supportsUniqueConstraints;
    }

    @Override
    public boolean supportsCatalogsOnReverseEngineering() {
        return true;
    }

    public void setSupportsUniqueConstraints(boolean flag) {
        this.supportsUniqueConstraints = flag;
    }

    @Override
    public boolean typeSupportsLength(int type) {
        return JdbcAdapter.supportsLength(type);
    }

    static boolean supportsLength(int type) {
        return type == -2 || type == 1 || type == -15 || type == -9 || type == -16 || type == 3 || type == 8 || type == 6 || type == 2 || type == 7 || type == -3 || type == 12;
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return Collections.singleton("DROP TABLE " + this.quotingStrategy.quotedFullyQualifiedName(table));
    }

    @Override
    public String createTable(DbEntity entity) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("CREATE TABLE ");
        sqlBuffer.append(this.quotingStrategy.quotedFullyQualifiedName(entity));
        sqlBuffer.append(" (");
        Iterator<DbAttribute> it = entity.getAttributes().iterator();
        if (it.hasNext()) {
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute column = it.next();
                if (column.getType() == Integer.MAX_VALUE) {
                    throw new CayenneRuntimeException("Undefined type for attribute '%s.%s'.", entity.getFullyQualifiedName(), column.getName());
                }
                this.createTableAppendColumn(sqlBuffer, column);
            }
            this.createTableAppendPKClause(sqlBuffer, entity);
        }
        sqlBuffer.append(')');
        return sqlBuffer.toString();
    }

    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        Iterator<DbAttribute> pkit = entity.getPrimaryKeys().iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute at = pkit.next();
                sqlBuffer.append(this.quotingStrategy.quotedName(at));
            }
            sqlBuffer.append(')');
        }
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        sqlBuffer.append(this.quotingStrategy.quotedName(column));
        sqlBuffer.append(' ').append(JdbcAdapter.getType(this, column));
        sqlBuffer.append(JdbcAdapter.sizeAndPrecision(this, column));
        sqlBuffer.append(column.isMandatory() ? " NOT NULL" : " NULL");
    }

    public static String sizeAndPrecision(DbAdapter adapter, DbAttribute column) {
        int scale;
        if (!adapter.typeSupportsLength(column.getType())) {
            return "";
        }
        int len = column.getMaxLength();
        int n = scale = TypesMapping.isDecimal(column.getType()) && column.getType() != 6 ? column.getScale() : -1;
        if (scale > len) {
            scale = -1;
        }
        if (len > 0) {
            return "(" + len + (scale >= 0 ? ", " + scale : "") + ")";
        }
        return "";
    }

    public static String getType(DbAdapter adapter, DbAttribute column) {
        String[] types = adapter.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? column.getEntity().getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '%s.%s': %s.", entityName, column.getName(), column.getType());
        }
        return types[0];
    }

    @Override
    public String createUniqueConstraint(DbEntity source, Collection<DbAttribute> columns) {
        if (columns == null || columns.isEmpty()) {
            throw new CayenneRuntimeException("Can't create UNIQUE constraint - no columns specified.", new Object[0]);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("ALTER TABLE ");
        buf.append(this.quotingStrategy.quotedFullyQualifiedName(source));
        buf.append(" ADD UNIQUE (");
        Iterator<DbAttribute> it = columns.iterator();
        DbAttribute first = it.next();
        buf.append(this.quotingStrategy.quotedName(first));
        while (it.hasNext()) {
            DbAttribute next = it.next();
            buf.append(", ");
            buf.append(this.quotingStrategy.quotedName(next));
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public String createFkConstraint(DbRelationship rel) {
        DbEntity source = rel.getSourceEntity();
        StringBuilder buf = new StringBuilder();
        StringBuilder refBuf = new StringBuilder();
        buf.append("ALTER TABLE ");
        buf.append(this.quotingStrategy.quotedFullyQualifiedName(source));
        buf.append(" ADD FOREIGN KEY (");
        boolean first = true;
        List<DbJoin> joins = rel.getJoins();
        if (rel.isToPK()) {
            List<DbAttribute> pks = rel.getTargetEntity().getPrimaryKeys();
            joins.sort(Comparator.comparingInt(join -> pks.indexOf(join.getTarget())));
        }
        for (DbJoin join2 : joins) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
                refBuf.append(", ");
            }
            buf.append(this.quotingStrategy.quotedSourceName(join2));
            refBuf.append(this.quotingStrategy.quotedTargetName(join2));
        }
        buf.append(") REFERENCES ");
        buf.append(this.quotingStrategy.quotedFullyQualifiedName(rel.getTargetEntity()));
        buf.append(" (").append(refBuf.toString()).append(')');
        return buf.toString();
    }

    @Override
    public String[] externalTypesForJdbcType(int type) {
        return this.typesHandler.externalTypesForJdbcType(type);
    }

    @Override
    public ExtendedTypeMap getExtendedTypes() {
        return this.extendedTypes;
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        DbAttribute attr = new DbAttribute();
        attr.setName(name);
        attr.setType(type);
        attr.setMandatory(!allowNulls);
        if (size >= 0) {
            attr.setMaxLength(size);
        }
        if (scale >= 0) {
            attr.setScale(scale);
        }
        return attr;
    }

    @Override
    public String tableTypeForTable() {
        return "TABLE";
    }

    @Override
    public String tableTypeForView() {
        return "VIEW";
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new JdbcActionBuilder(node));
    }

    @Override
    public SelectTranslator getSelectTranslator(SelectQuery<?> query, EntityResolver entityResolver) {
        return new DefaultSelectTranslator(query, (DbAdapter)this, entityResolver);
    }

    @Override
    public SelectTranslator getSelectTranslator(FluentSelect<?> query, EntityResolver entityResolver) {
        return new DefaultSelectTranslator(query, (DbAdapter)this, entityResolver);
    }

    @Override
    public Function<Node, Node> getSqlTreeProcessor() {
        return Function.identity();
    }

    @Override
    public void bindParameter(PreparedStatement statement, ParameterBinding binding) throws Exception {
        if (binding.getValue() == null) {
            statement.setNull(binding.getStatementPosition(), binding.getJdbcType());
        } else {
            binding.getExtendedType().setJdbcObject(statement, binding.getValue(), binding.getStatementPosition(), binding.getJdbcType(), binding.getScale());
        }
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    public void setSupportsBatchUpdates(boolean flag) {
        this.supportsBatchUpdates = flag;
    }

    @Override
    public boolean supportsGeneratedKeys() {
        return this.supportsGeneratedKeys;
    }

    public void setSupportsGeneratedKeys(boolean flag) {
        this.supportsGeneratedKeys = flag;
    }

    @Override
    public EJBQLTranslatorFactory getEjbqlTranslatorFactory() {
        return this.ejbqlTranslatorFactory;
    }

    @Override
    public List<String> getSystemCatalogs() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getSystemSchemas() {
        return Collections.emptyList();
    }

    public void setEjbqlTranslatorFactory(EJBQLTranslatorFactory ejbqlTranslatorFactory) {
        this.ejbqlTranslatorFactory = ejbqlTranslatorFactory;
    }

    protected QuotingStrategy createQuotingStrategy() {
        return new DefaultQuotingStrategy("\"", "\"");
    }

    @Override
    public QuotingStrategy getQuotingStrategy() {
        return this.quotingStrategy;
    }

    @Override
    public DbAdapter unwrap() {
        return this;
    }
}

