/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.sqlbuilder.sqltree.ValueNode;

public class TrimmingColumnNode
extends Node {
    protected final ColumnNode columnNode;

    public TrimmingColumnNode(ColumnNode columnNode) {
        this.columnNode = columnNode;
    }

    @Override
    public QuotingAppendable append(QuotingAppendable buffer) {
        boolean isResult = this.isResultNode();
        if (this.columnNode.getAlias() == null || isResult) {
            if (this.isCharType() && this.isAllowedForTrimming()) {
                this.appendRtrim(buffer);
                this.appendAlias(buffer, isResult);
            } else if (this.isComparisionWithClob()) {
                this.appendClobColumnNode(buffer);
                this.appendAlias(buffer, isResult);
            } else {
                this.columnNode.append(buffer);
            }
        } else {
            this.appendAlias(buffer, false);
        }
        return buffer;
    }

    private boolean isComparisionWithClob() {
        return (this.getParent().getType() == NodeType.EQUALITY || this.getParent().getType() == NodeType.LIKE) && this.columnNode.getAttribute() != null && this.columnNode.getAttribute().getType() == 2005;
    }

    protected void appendRtrim(QuotingAppendable buffer) {
        buffer.append(" RTRIM(");
        this.appendColumnNode(buffer);
        buffer.append(")");
    }

    private boolean isCharType() {
        return this.columnNode.getAttribute() != null && this.columnNode.getAttribute().getType() == 1;
    }

    protected boolean isAllowedForTrimming() {
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != NodeType.JOIN && parent.getType() != NodeType.FUNCTION) continue;
            return false;
        }
        return true;
    }

    protected boolean isResultNode() {
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != NodeType.RESULT) continue;
            return true;
        }
        return false;
    }

    protected void appendClobColumnNode(QuotingAppendable buffer) {
        buffer.append(" CAST(");
        this.appendColumnNode(buffer);
        buffer.append(" AS VARCHAR(").append(this.getColumnSize()).append("))");
    }

    protected void appendColumnNode(QuotingAppendable buffer) {
        if (this.columnNode.getTable() != null) {
            buffer.appendQuoted(this.columnNode.getTable()).append('.');
        }
        buffer.appendQuoted(this.columnNode.getColumn());
    }

    protected void appendAlias(QuotingAppendable buffer, boolean isResult) {
        if (!isResult) {
            return;
        }
        if (this.columnNode.getAlias() != null) {
            buffer.append(' ').appendQuoted(this.columnNode.getAlias());
        }
    }

    protected int getColumnSize() {
        int size = this.columnNode.getAttribute().getMaxLength();
        if (size > 0) {
            return size;
        }
        int siblings = this.getParent().getChildrenCount();
        for (int i = 0; i < siblings; ++i) {
            Node sibling = this.getParent().getChild(i);
            if (sibling == this || sibling.getType() != NodeType.VALUE || !(((ValueNode)sibling).getValue() instanceof CharSequence)) continue;
            return ((CharSequence)((ValueNode)sibling).getValue()).length();
        }
        return 255;
    }

    @Override
    public Node copy() {
        return new TrimmingColumnNode((ColumnNode)this.columnNode.deepCopy());
    }
}

