/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.function.BiFunction;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DbRowOpWithValues;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.DeleteInsertDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;

public class DbRowOpMerger
implements DbRowOpVisitor<DbRowOp>,
BiFunction<DbRowOp, DbRowOp, DbRowOp> {
    public static final DbRowOpMerger INSTANCE = new DbRowOpMerger();
    private DbRowOp dbRow;

    @Override
    public DbRowOp apply(DbRowOp oldValue, DbRowOp newValue) {
        this.dbRow = oldValue;
        return newValue.accept(this);
    }

    @Override
    public DbRowOp visitInsert(InsertDbRowOp other) {
        if (this.dbRow instanceof DeleteDbRowOp) {
            return new DeleteInsertDbRowOp((DeleteDbRowOp)this.dbRow, other);
        }
        return this.mergeValues((DbRowOpWithValues)this.dbRow, other);
    }

    @Override
    public DbRowOp visitUpdate(UpdateDbRowOp other) {
        if (this.dbRow instanceof DeleteDbRowOp) {
            return this.dbRow;
        }
        return this.mergeValues((DbRowOpWithValues)this.dbRow, other);
    }

    @Override
    public DbRowOp visitDelete(DeleteDbRowOp other) {
        if (this.dbRow.getChangeId() == other.getChangeId()) {
            return other;
        }
        if (this.dbRow instanceof InsertDbRowOp) {
            return new DeleteInsertDbRowOp(other, (InsertDbRowOp)this.dbRow);
        }
        return other;
    }

    private DbRowOp mergeValues(DbRowOpWithValues left, DbRowOpWithValues right) {
        if (right.getChangeId() == right.getObject().getObjectId()) {
            right.getValues().merge(left.getValues());
            return right;
        }
        left.getValues().merge(right.getValues());
        return left;
    }
}

