/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.unit.UnitDbAdapter;

public class OracleUnitDbAdapter
extends UnitDbAdapter {
    public OracleUnitDbAdapter(DbAdapter adapter) {
        super(adapter);
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsBoolean() {
        return false;
    }

    public void willDropTables(Connection conn, DataMap map, Collection tablesToDrop) throws Exception {
    }

    @Override
    public void willCreateTables(Connection con, DataMap map) {
        DbEntity paintingInfo = map.getDbEntity("PAINTING_INFO");
        if (paintingInfo != null) {
            DbAttribute textReview = paintingInfo.getAttribute("TEXT_REVIEW");
            textReview.setType(12);
            textReview.setMaxLength(255);
        }
    }

    @Override
    public void createdTables(Connection con, DataMap map) throws Exception {
        if (map.getProcedureMap().containsKey("cayenne_tst_select_proc")) {
            this.executeDDL(con, "oracle", "create-types-pkg.sql");
            this.executeDDL(con, "oracle", "create-select-sp.sql");
            this.executeDDL(con, "oracle", "create-update-sp.sql");
            this.executeDDL(con, "oracle", "create-update-sp2.sql");
            this.executeDDL(con, "oracle", "create-out-sp.sql");
        }
    }

    @Override
    public boolean supportsLobs() {
        return true;
    }

    @Override
    public boolean supportsLobComparisons() {
        return false;
    }

    @Override
    public void tweakProcedure(Procedure proc) {
        if ("cayenne_tst_select_proc".equals(proc.getName()) && proc.getCallParameters().size() == 2) {
            ArrayList<ProcedureParameter> params = new ArrayList<ProcedureParameter>(proc.getCallParameters());
            proc.clearCallParameters();
            proc.addCallParameter(new ProcedureParameter("result", OracleAdapter.getOracleCursorType(), 2));
            for (ProcedureParameter param : params) {
                proc.addCallParameter(param);
            }
            proc.setReturningValue(true);
        }
    }

    @Override
    public boolean onlyGenericDateType() {
        return true;
    }

    @Override
    public boolean onlyGenericNumberType() {
        return true;
    }

    @Override
    public boolean supportsTimeSqlType() {
        return false;
    }

    @Override
    public boolean supportsExpressionInHaving() {
        return false;
    }

    @Override
    public boolean supportsSelectBooleanExpression() {
        return false;
    }

    @Override
    public boolean supportsSerializableTransactionIsolation() {
        return true;
    }
}

