/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.template.CayenneSQLTemplateProcessor;
import org.apache.cayenne.template.DefaultTemplateContextFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CayenneSQLTemplateProcessorTest {
    private CayenneSQLTemplateProcessor processor;

    @Before
    public void before() {
        this.processor = new CayenneSQLTemplateProcessor(new DefaultTemplateContextFactory());
    }

    @Test
    public void testProcessTemplateUnchanged1() throws Exception {
        String sqlTemplate = "SELECT * FROM ME";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)sqlTemplate, (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
    }

    @Test
    public void testProcessTemplateUnchanged2() throws Exception {
        String sqlTemplate = "SELECT a.b as XYZ FROM $SYSTEM_TABLE";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)sqlTemplate, (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
    }

    @Test
    public void testProcessTemplateSimpleDynamicContent() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE $a";
        Map<String, String> map = Collections.singletonMap("a", "VALUE_OF_A");
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE VALUE_OF_A", (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
    }

    @Test
    public void testProcessTemplateBind() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE COLUMN1 = #bind($a 'VARCHAR') AND COLUMN2 = #bind($b 'INTEGER')";
        Map<String, String> map = Collections.singletonMap("a", "VALUE_OF_A");
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE COLUMN1 = ? AND COLUMN2 = ?", (Object)compiled.getSql());
        Assert.assertEquals((long)2L, (long)compiled.getBindings().length);
        this.assertBindingValue("VALUE_OF_A", compiled.getBindings()[0]);
        this.assertBindingValue(null, compiled.getBindings()[1]);
    }

    @Test
    public void testProcessTemplateBindGuessVarchar() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE COLUMN1 = #bind($a)";
        Map<String, String> map = Collections.singletonMap("a", "VALUE_OF_A");
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((long)1L, (long)compiled.getBindings().length);
        this.assertBindingType(12, compiled.getBindings()[0]);
    }

    @Test
    public void testProcessTemplateBindGuessInteger() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE COLUMN1 = #bind($a)";
        Map<String, Integer> map = Collections.singletonMap("a", 4);
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((long)1L, (long)compiled.getBindings().length);
        this.assertBindingType(4, compiled.getBindings()[0]);
    }

    @Test
    public void testProcessTemplateBindEqual() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE COLUMN #bindEqual($a 'VARCHAR')";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE COLUMN IS NULL", (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
        Map<String, String> map = Collections.singletonMap("a", "VALUE_OF_A");
        compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE COLUMN = ?", (Object)compiled.getSql());
        Assert.assertEquals((long)1L, (long)compiled.getBindings().length);
        this.assertBindingValue("VALUE_OF_A", compiled.getBindings()[0]);
    }

    @Test
    public void testProcessTemplateBindNotEqual() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE COLUMN #bindNotEqual($a 'VARCHAR')";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE COLUMN IS NOT NULL", (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
        Map<String, String> map = Collections.singletonMap("a", "VALUE_OF_A");
        compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE COLUMN <> ?", (Object)compiled.getSql());
        Assert.assertEquals((long)1L, (long)compiled.getBindings().length);
        this.assertBindingValue("VALUE_OF_A", compiled.getBindings()[0]);
    }

    @Test
    public void testProcessTemplateID() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE COLUMN1 = #bind($helper.cayenneExp($a, 'db:ID_COLUMN'))";
        CayenneDataObject dataObject = new CayenneDataObject();
        dataObject.setObjectId(ObjectId.of("T", "ID_COLUMN", 5));
        Map<String, CayenneDataObject> map = Collections.singletonMap("a", dataObject);
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE COLUMN1 = ?", (Object)compiled.getSql());
        Assert.assertEquals((long)1L, (long)compiled.getBindings().length);
        this.assertBindingValue(5, compiled.getBindings()[0]);
    }

    @Test
    public void testProcessTemplateNotEqualID() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE COLUMN1 #bindNotEqual($helper.cayenneExp($a, 'db:ID_COLUMN1')) AND COLUMN2 #bindNotEqual($helper.cayenneExp($a, 'db:ID_COLUMN2'))";
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        idMap.put("ID_COLUMN1", 3);
        idMap.put("ID_COLUMN2", "aaa");
        ObjectId id = ObjectId.of("T", idMap);
        CayenneDataObject dataObject = new CayenneDataObject();
        dataObject.setObjectId(id);
        Map<String, CayenneDataObject> map = Collections.singletonMap("a", dataObject);
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE COLUMN1 <> ? AND COLUMN2 <> ?", (Object)compiled.getSql());
        Assert.assertEquals((long)2L, (long)compiled.getBindings().length);
        this.assertBindingValue(3, compiled.getBindings()[0]);
        this.assertBindingValue("aaa", compiled.getBindings()[1]);
    }

    @Test
    public void testProcessTemplateConditions() throws Exception {
        String sqlTemplate = "SELECT * FROM ME #if($a) WHERE COLUMN1 > #bind($a)#end";
        Map<String, String> map = Collections.singletonMap("a", "VALUE_OF_A");
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((Object)"SELECT * FROM ME  WHERE COLUMN1 > ?", (Object)compiled.getSql());
        Assert.assertEquals((long)1L, (long)compiled.getBindings().length);
        this.assertBindingValue("VALUE_OF_A", compiled.getBindings()[0]);
        compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)"SELECT * FROM ME ", (Object)compiled.getSql());
        Assert.assertEquals((long)0L, (long)compiled.getBindings().length);
    }

    @Test
    public void testProcessTemplateBindCollection() throws Exception {
        String sqlTemplate = "SELECT * FROM ME WHERE COLUMN IN (#bind($list 'VARCHAR'))";
        Map<String, List<String>> map = Collections.singletonMap("list", Arrays.asList("a", "b", "c"));
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, map);
        Assert.assertEquals((Object)"SELECT * FROM ME WHERE COLUMN IN (?,?,?)", (Object)compiled.getSql());
        Assert.assertEquals((long)3L, (long)compiled.getBindings().length);
        this.assertBindingValue("a", compiled.getBindings()[0]);
        this.assertBindingValue("b", compiled.getBindings()[1]);
        this.assertBindingValue("c", compiled.getBindings()[2]);
    }

    @Test
    public void testUnknownDirective() throws Exception {
        String sqlTemplate = "SELECT #from(1) FROM a";
        SQLStatement compiled = this.processor.processTemplate(sqlTemplate, Collections.emptyMap());
        Assert.assertEquals((Object)"SELECT  FROM a", (Object)compiled.getSql());
    }

    private void assertBindingValue(Object expectedValue, Object binding) {
        Assert.assertTrue((String)"Not a binding!", (boolean)(binding instanceof ParameterBinding));
        Assert.assertEquals((Object)expectedValue, (Object)((ParameterBinding)binding).getValue());
    }

    private void assertBindingType(Integer expectedType, Object binding) {
        Assert.assertTrue((String)"Not a binding!", (boolean)(binding instanceof ParameterBinding));
        Assert.assertEquals((Object)expectedType, (Object)((ParameterBinding)binding).getJdbcType());
    }
}

