/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.XMLEncoder;

@Deprecated
public class SelectQueryDescriptor
extends QueryDescriptor {
    private static final long serialVersionUID = -8798258795351950215L;
    protected Expression qualifier;
    protected List<Ordering> orderings = new ArrayList<Ordering>();
    protected Map<String, Integer> prefetchesMap = new HashMap<String, Integer>();

    public SelectQueryDescriptor() {
        super("SelectQuery");
    }

    public void setDistinct(boolean value) {
        this.setProperty("cayenne.SelectQuery.distinct", String.valueOf(value));
    }

    public boolean isDistinct() {
        String distinct = this.getProperty("cayenne.SelectQuery.distinct");
        return distinct != null ? Boolean.valueOf(distinct) : false;
    }

    public Expression getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public List<Ordering> getOrderings() {
        return this.orderings;
    }

    public void setOrderings(List<Ordering> orderings) {
        this.orderings = orderings;
    }

    public void addOrdering(Ordering ordering) {
        this.orderings.add(ordering);
    }

    public void removeOrdering(Ordering ordering) {
        this.orderings.remove(ordering);
    }

    public Map<String, Integer> getPrefetchesMap() {
        return this.prefetchesMap;
    }

    @Deprecated
    public List<String> getPrefetches() {
        return new ArrayList<String>(this.prefetchesMap.keySet());
    }

    public void setPrefetchesMap(HashMap<String, Integer> prefetchesMap) {
        this.prefetchesMap = prefetchesMap;
    }

    @Deprecated
    public void setPrefetches(List<String> prefetches) {
        for (String prefetch : prefetches) {
            this.prefetchesMap.put(prefetch, 1);
        }
    }

    public void addPrefetch(String prefetchPath, int semantics) {
        this.prefetchesMap.put(prefetchPath, semantics);
    }

    @Deprecated
    public void addPrefetch(String prefetchPath) {
        this.prefetchesMap.put(prefetchPath, 1);
    }

    public void removePrefetch(String prefetchPath) {
        this.prefetchesMap.remove(prefetchPath);
    }

    @Override
    public SelectQuery<?> buildQuery() {
        SelectQuery selectQuery = new SelectQuery();
        selectQuery.setRoot(this.getRoot());
        selectQuery.setQualifier(this.getQualifier());
        List<Ordering> orderings = this.getOrderings();
        if (orderings != null && !orderings.isEmpty()) {
            selectQuery.addOrderings(orderings);
        }
        if (this.prefetchesMap != null) {
            for (Map.Entry<String, Integer> entry : this.prefetchesMap.entrySet()) {
                selectQuery.addPrefetch(PrefetchTreeNode.withPath(entry.getKey(), entry.getValue()));
            }
        }
        selectQuery.initWithProperties(this.getProperties());
        return selectQuery;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("query").attribute("name", this.getName()).attribute("type", this.type);
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        }
        if (rootType != null) {
            encoder.attribute("root", rootType).attribute("root-name", rootString);
        }
        this.encodeProperties(encoder);
        if (this.qualifier != null) {
            encoder.start("qualifier").nested(this.qualifier, delegate).end();
        }
        encoder.nested(this.orderings, delegate);
        PrefetchTreeNode prefetchTree = new PrefetchTreeNode();
        for (String prefetchPath : this.prefetchesMap.keySet()) {
            PrefetchTreeNode node = prefetchTree.addPath(prefetchPath);
            node.setSemantics(this.prefetchesMap.get(prefetchPath));
            node.setPhantom(false);
        }
        encoder.nested(prefetchTree, delegate);
        delegate.visitQuery(this);
        encoder.end();
    }
}

