/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTLike;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.reflect.TstJavaBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasePropertyTest {
    private BaseProperty<Integer> property;

    @Before
    public void createProperty() {
        this.property = new BaseProperty<Integer>("path", null, Integer.class);
    }

    @Test
    public void testPathExpConstructor() {
        Assert.assertEquals((Object)new ASTObjPath("path"), (Object)this.property.getExpression());
    }

    @Test
    public void testCustomExpConstructor() {
        this.property = new BaseProperty<Integer>("path", new ASTLike(), Integer.class);
        Assert.assertEquals((Object)new ASTLike(), (Object)this.property.getExpression());
    }

    @Test
    public void testEq() {
        Expression exp = this.property.eq(1);
        Assert.assertEquals((Object)ExpressionFactory.exp("path = 1", new Object[0]), (Object)exp);
    }

    @Test
    public void testNe() {
        Expression exp = this.property.ne(1);
        Assert.assertEquals((Object)ExpressionFactory.exp("path != 1", new Object[0]), (Object)exp);
    }

    @Test
    public void testIn() {
        Expression exp = this.property.in(1, (Integer[])new Integer[]{2, 3});
        Assert.assertEquals((Object)ExpressionFactory.exp("path in (1, 2, 3)", new Object[0]), (Object)exp);
    }

    @Test
    public void testInCollection() {
        Expression exp = this.property.in(Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)ExpressionFactory.exp("path in (1, 2, 3)", new Object[0]), (Object)exp);
    }

    @Test
    public void testNin() {
        Expression exp = this.property.nin(1, (Integer[])new Integer[]{2, 3});
        Assert.assertEquals((Object)ExpressionFactory.exp("path not in (1, 2, 3)", new Object[0]), (Object)exp);
    }

    @Test
    public void testNinCollection() {
        Expression exp = this.property.nin(Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)ExpressionFactory.exp("path not in (1, 2, 3)", new Object[0]), (Object)exp);
    }

    @Test
    public void testIsNull() {
        BaseProperty<Integer> property = new BaseProperty<Integer>("path", null, Integer.class);
        Expression exp = property.isNull();
        Assert.assertEquals((Object)ExpressionFactory.exp("path = null", new Object[0]), (Object)exp);
    }

    @Test
    public void testNotIsNull() {
        Expression exp = this.property.isNotNull();
        Assert.assertEquals((Object)ExpressionFactory.exp("path != null", new Object[0]), (Object)exp);
    }

    @Test
    public void testIsTrue() {
        Expression exp = this.property.isTrue();
        Assert.assertEquals((Object)ExpressionFactory.exp("path = true", new Object[0]), (Object)exp);
    }

    @Test
    public void testIsFalse() {
        Expression exp = this.property.isFalse();
        Assert.assertEquals((Object)ExpressionFactory.exp("path = false", new Object[0]), (Object)exp);
    }

    @Test
    public void testAlias() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        Assert.assertNull((Object)this.property.getAlias());
        this.property = this.property.alias("test");
        Assert.assertEquals((Object)"test", (Object)this.property.getName());
        Assert.assertEquals((Object)"test", (Object)this.property.getAlias());
        Assert.assertEquals((Object)new ASTObjPath("path"), (Object)this.property.getExpression());
    }

    @Test
    public void testGetFrom() {
        TstJavaBean bean = new TstJavaBean();
        bean.setIntField(7);
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>("intField", null, Integer.class);
        Assert.assertEquals((Object)7, (Object)INT_FIELD.getFrom(bean));
    }

    @Test
    public void testGetFromNestedProperty() {
        TstJavaBean bean = new TstJavaBean();
        TstJavaBean nestedBean = new TstJavaBean();
        nestedBean.setIntField(7);
        bean.setObjectField(nestedBean);
        BaseProperty<Integer> OBJECT_FIELD_INT_FIELD = new BaseProperty<Integer>("objectField.intField", null, Integer.class);
        Assert.assertEquals((Object)7, (Object)OBJECT_FIELD_INT_FIELD.getFrom(bean));
    }

    @Test
    public void testGetFromNestedNull() {
        TstJavaBean bean = new TstJavaBean();
        bean.setObjectField(null);
        BaseProperty<Integer> OBJECT_FIELD_INT_FIELD = new BaseProperty<Integer>("objectField.intField", null, Integer.class);
        Assert.assertNull((Object)OBJECT_FIELD_INT_FIELD.getFrom(bean));
    }

    @Test
    public void testGetFromAll() {
        TstJavaBean bean = new TstJavaBean();
        bean.setIntField(7);
        TstJavaBean bean2 = new TstJavaBean();
        bean2.setIntField(8);
        List<TstJavaBean> beans = Arrays.asList(bean, bean2);
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>("intField", null, Integer.class);
        Assert.assertEquals(Arrays.asList(7, 8), INT_FIELD.getFromAll(beans));
    }

    @Test
    public void testSetIn() {
        TstJavaBean bean = new TstJavaBean();
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>("intField", null, Integer.class);
        INT_FIELD.setIn(bean, 7);
        Assert.assertEquals((long)7L, (long)bean.getIntField());
    }

    @Test
    public void testSetInNestedProperty() {
        TstJavaBean bean = new TstJavaBean();
        bean.setObjectField(new TstJavaBean());
        BaseProperty<Integer> OBJECT_FIELD_INT_FIELD = new BaseProperty<Integer>("objectField.intField", null, Integer.class);
        OBJECT_FIELD_INT_FIELD.setIn(bean, 7);
        Assert.assertEquals((long)7L, (long)((TstJavaBean)bean.getObjectField()).getIntField());
    }

    @Test
    public void testSetInNestedNull() {
        TstJavaBean bean = new TstJavaBean();
        bean.setObjectField(null);
        BaseProperty<Integer> OBJECT_FIELD_INT_FIELD = new BaseProperty<Integer>("objectField.intField", null, Integer.class);
        OBJECT_FIELD_INT_FIELD.setIn(bean, 7);
    }

    @Test
    public void testSetInAll() {
        TstJavaBean bean = new TstJavaBean();
        TstJavaBean bean2 = new TstJavaBean();
        List<TstJavaBean> beans = Arrays.asList(bean, bean2);
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>("intField", null, Integer.class);
        INT_FIELD.setInAll(beans, 7);
        Assert.assertEquals((long)7L, (long)bean.getIntField());
        Assert.assertEquals((long)7L, (long)bean2.getIntField());
    }

    @Test
    public void testEqualsWithName() {
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>("intField", null, Integer.class);
        BaseProperty<Integer> INT_FIELD2 = new BaseProperty<Integer>("intField", null, Integer.class);
        Assert.assertNotSame(INT_FIELD, INT_FIELD2);
        Assert.assertEquals(INT_FIELD, INT_FIELD2);
    }

    @Test
    public void testHashCodeWithName() {
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>("intField", null, Integer.class);
        BaseProperty<Integer> INT_FIELD2 = new BaseProperty<Integer>("intField", null, Integer.class);
        BaseProperty<Long> LONG_FIELD = new BaseProperty<Long>("longField", null, Long.class);
        Assert.assertEquals((long)INT_FIELD.hashCode(), (long)INT_FIELD2.hashCode());
        Assert.assertNotSame((Object)INT_FIELD.hashCode(), (Object)LONG_FIELD.hashCode());
    }

    @Test
    public void testEqualsWithNameAndType() {
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>("intField", null, Integer.class);
        BaseProperty<Integer> INT_FIELD2 = new BaseProperty<Integer>("intField", null, Integer.class);
        Assert.assertNotSame(INT_FIELD, INT_FIELD2);
        Assert.assertEquals(INT_FIELD, INT_FIELD2);
    }

    @Test
    public void testHashCodeWithNameAndType() {
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>("intField", null, Integer.class);
        BaseProperty<Integer> INT_FIELD2 = new BaseProperty<Integer>("intField", null, Integer.class);
        BaseProperty<Long> LONG_FIELD = new BaseProperty<Long>("longField", null, Long.class);
        Assert.assertEquals((long)INT_FIELD.hashCode(), (long)INT_FIELD2.hashCode());
        Assert.assertNotEquals((long)INT_FIELD.hashCode(), (long)LONG_FIELD.hashCode());
    }

    @Test
    public void testEqualsWithExpAndType() {
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>(null, ExpressionFactory.exp("1", new Object[0]), Integer.class);
        BaseProperty<Integer> INT_FIELD2 = new BaseProperty<Integer>(null, ExpressionFactory.exp("1", new Object[0]), Integer.class);
        Assert.assertNotSame(INT_FIELD, INT_FIELD2);
        Assert.assertEquals(INT_FIELD, INT_FIELD2);
    }

    @Test
    public void testHashCodeWithExpAndType() {
        BaseProperty<Integer> INT_FIELD = new BaseProperty<Integer>(null, ExpressionFactory.exp("1", new Object[0]), Integer.class);
        BaseProperty<Integer> INT_FIELD2 = new BaseProperty<Integer>(null, ExpressionFactory.exp("1", new Object[0]), Integer.class);
        BaseProperty<Integer> INT_FIELD3 = new BaseProperty<Integer>(null, ExpressionFactory.exp("2", new Object[0]), Integer.class);
        Assert.assertEquals((long)INT_FIELD.hashCode(), (long)INT_FIELD2.hashCode());
        Assert.assertNotEquals((long)INT_FIELD.hashCode(), (long)INT_FIELD3.hashCode());
    }
}

