/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.reflect.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTObjPath
extends ASTPath {
    private static final long serialVersionUID = -3574281576491705706L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ASTObjPath.class);
    public static final String OBJ_PREFIX = "obj:";

    ASTObjPath(int id) {
        super(id);
    }

    public ASTObjPath() {
        super(56);
    }

    public ASTObjPath(Object value) {
        super(56);
        this.setPath(value);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        return o instanceof DataObject ? ((DataObject)o).readNestedProperty(this.path) : (o instanceof Entity ? this.evaluateEntityNode((Entity)o) : PropertyUtils.getProperty(o, this.path));
    }

    @Override
    public Expression shallowCopy() {
        ASTObjPath copy = new ASTObjPath(this.id);
        copy.path = this.path;
        copy.setPathAliases(this.pathAliases);
        return copy;
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        out.append(rootId);
        out.append('.');
        out.append(this.path);
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append(this.path);
    }

    @Override
    public int getType() {
        return 26;
    }

    void injectValue(Object source, Object value) {
        if (!this.getPath().contains(".")) {
            try {
                if (source instanceof DataObject) {
                    ((DataObject)source).writeProperty(this.getPath(), value);
                } else {
                    PropertyUtils.setProperty(source, this.getPath(), value);
                }
            }
            catch (CayenneRuntimeException ex) {
                LOGGER.warn("Failed to inject value " + value + " on path " + this.getPath() + " to " + source, (Throwable)ex);
            }
        }
    }
}

