/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTLocate;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class ASTLocateTest {
    @Test
    public void testEvaluateLocate() throws Exception {
        ASTObjPath path = new ASTObjPath("artistName");
        ASTScalar substr = new ASTScalar("678");
        ASTScalar offset = new ASTScalar((Object)5);
        ASTLocate exp = new ASTLocate(substr, path, offset);
        Artist a = new Artist();
        a.setArtistName("1267834567890abc");
        Object res = exp.evaluateNode(a);
        Assert.assertTrue((boolean)(res instanceof Integer));
        Assert.assertEquals((Object)9, (Object)res);
        a.setArtistName("abcdefgh");
        res = exp.evaluateNode(a);
        Assert.assertTrue((boolean)(res instanceof Integer));
        Assert.assertEquals((Object)0, (Object)res);
    }

    @Test
    public void parseTest() throws Exception {
        String expString = "locate(\"xyz\" , abc , 4)";
        Expression exp = ExpressionFactory.exp(expString, new Object[0]);
        Assert.assertTrue((boolean)(exp instanceof ASTLocate));
        String toString = exp.toString();
        Assert.assertEquals((Object)expString, (Object)toString);
    }
}

