/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Date;
import junit.framework.TestCase;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ASTFunctionCallStringIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    private Artist createArtist(String name) throws Exception {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName(name);
        a1.setDateOfBirth(new Date());
        this.context.commitChanges();
        return a1;
    }

    @Test
    public void testASTTrimInWhere() throws Exception {
        Artist a1 = this.createArtist("  name  ");
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.trim().eq("name")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTUpperInWhere() throws Exception {
        Artist a1 = this.createArtist("name");
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.upper().eq("NAME")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTLowerInWhere() throws Exception {
        Artist a1 = this.createArtist("NAME");
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.lower().eq("name")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTSubstringInWhere() throws Exception {
        Artist a1 = this.createArtist("1234567890xyz");
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.substring(2, 8).eq("23456789")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTConcat() throws Exception {
        Artist a1 = this.createArtist("Pablo");
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.trim().concat(" ", "Picasso").eq("Pablo Picasso")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTLength() throws Exception {
        Artist a1 = this.createArtist("123456");
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.length().gt(5)).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
        Artist a3 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.length().lt(5)).selectOne(this.context);
        TestCase.assertNull((Object)a3);
    }

    @Test
    public void testASTLocate() throws Exception {
        Artist a1 = this.createArtist("1267834567890abc");
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.locate("678").eq(3)).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testCombinedFunction() throws Exception {
        Artist a1 = this.createArtist("absdefghij  klmnopq");
        Artist a2 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.substring(3, 10).trim().upper().concat(" ", "test").eq("SDEFGHIJ test")).selectOne(this.context);
        TestCase.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void testASTConcatParse() {
        Expression exp = ExpressionFactory.exp("concat('abc', 'def')", new Object[0]);
        TestCase.assertEquals((Object)"abcdef", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTSubstringParse() {
        Expression exp = ExpressionFactory.exp("substring('123456789', 3, 2)", new Object[0]);
        TestCase.assertEquals((Object)"34", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTTrimParse() {
        Expression exp = ExpressionFactory.exp("trim(' abc ')", new Object[0]);
        TestCase.assertEquals((Object)"abc", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTLowerParse() {
        Expression exp = ExpressionFactory.exp("lower('AbC')", new Object[0]);
        TestCase.assertEquals((Object)"abc", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTUpperParse() {
        Expression exp = ExpressionFactory.exp("upper('aBc')", new Object[0]);
        TestCase.assertEquals((Object)"ABC", (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testASTLocateParse() {
        Expression exp = ExpressionFactory.exp("locate('Bc', 'aBc')", new Object[0]);
        TestCase.assertEquals((Object)2, (Object)exp.evaluate(new Object()));
    }

    @Test
    public void testComplexParse() {
        Expression exp = ExpressionFactory.exp("locate(upper('Bc'), upper('aBc')) = length(substring(trim(lower(concat('   abc', 'def   '))), 3, 2))", new Object[0]);
        TestCase.assertEquals((Object)true, (Object)exp.evaluate(new Object()));
    }
}

