/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.parser.ASTAbs;
import org.apache.cayenne.exp.parser.ASTAsterisk;
import org.apache.cayenne.exp.parser.ASTAvg;
import org.apache.cayenne.exp.parser.ASTConcat;
import org.apache.cayenne.exp.parser.ASTCount;
import org.apache.cayenne.exp.parser.ASTCurrentDate;
import org.apache.cayenne.exp.parser.ASTCurrentTime;
import org.apache.cayenne.exp.parser.ASTCurrentTimestamp;
import org.apache.cayenne.exp.parser.ASTLength;
import org.apache.cayenne.exp.parser.ASTLocate;
import org.apache.cayenne.exp.parser.ASTLower;
import org.apache.cayenne.exp.parser.ASTMax;
import org.apache.cayenne.exp.parser.ASTMin;
import org.apache.cayenne.exp.parser.ASTMod;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ASTSqrt;
import org.apache.cayenne.exp.parser.ASTSubstring;
import org.apache.cayenne.exp.parser.ASTSum;
import org.apache.cayenne.exp.parser.ASTTrim;
import org.apache.cayenne.exp.parser.ASTUpper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class FunctionExpressionFactoryTest {
    @Test
    public void substringExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.getExpression(), 10, 15);
        Expression exp2 = FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.getName(), 10, 15);
        Expression exp3 = FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.getExpression(), new ASTScalar((Object)10), new ASTScalar((Object)15));
        Assert.assertTrue((boolean)(exp1 instanceof ASTSubstring));
        Assert.assertEquals((long)3L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)10, (Object)exp1.getOperand(1));
        Assert.assertEquals((Object)15, (Object)exp1.getOperand(2));
        Assert.assertEquals((Object)exp1, (Object)exp2);
        Assert.assertEquals((Object)exp2, (Object)exp3);
    }

    @Test
    public void trimExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.trimExp(Artist.ARTIST_NAME.getExpression());
        Expression exp2 = FunctionExpressionFactory.trimExp(Artist.ARTIST_NAME.getName());
        Assert.assertTrue((boolean)(exp1 instanceof ASTTrim));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)exp1, (Object)exp2);
    }

    @Test
    public void lowerExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.lowerExp(Artist.ARTIST_NAME.getExpression());
        Expression exp2 = FunctionExpressionFactory.lowerExp(Artist.ARTIST_NAME.getName());
        Assert.assertTrue((boolean)(exp1 instanceof ASTLower));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)exp1, (Object)exp2);
    }

    @Test
    public void upperExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.upperExp(Artist.ARTIST_NAME.getExpression());
        Expression exp2 = FunctionExpressionFactory.upperExp(Artist.ARTIST_NAME.getName());
        Assert.assertTrue((boolean)(exp1 instanceof ASTUpper));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)exp1, (Object)exp2);
    }

    @Test
    public void lengthExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.lengthExp(Artist.ARTIST_NAME.getExpression());
        Expression exp2 = FunctionExpressionFactory.lengthExp(Artist.ARTIST_NAME.getName());
        Assert.assertTrue((boolean)(exp1 instanceof ASTLength));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)exp1, (Object)exp2);
    }

    @Test
    public void locateExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.locateExp("abc", Artist.ARTIST_NAME.getExpression());
        Expression exp2 = FunctionExpressionFactory.locateExp("abc", Artist.ARTIST_NAME.getName());
        Expression exp3 = FunctionExpressionFactory.locateExp(new ASTScalar("abc"), Artist.ARTIST_NAME.getExpression());
        Assert.assertTrue((boolean)(exp1 instanceof ASTLocate));
        Assert.assertEquals((long)2L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)"abc", (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(1));
        Assert.assertEquals((Object)exp1, (Object)exp2);
        Assert.assertEquals((Object)exp2, (Object)exp3);
    }

    @Test
    public void absExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.absExp(Artist.ARTIST_NAME.getExpression());
        Expression exp2 = FunctionExpressionFactory.absExp(Artist.ARTIST_NAME.getName());
        Assert.assertTrue((boolean)(exp1 instanceof ASTAbs));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)exp1, (Object)exp2);
    }

    @Test
    public void sqrtExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.sqrtExp(Artist.ARTIST_NAME.getExpression());
        Expression exp2 = FunctionExpressionFactory.sqrtExp(Artist.ARTIST_NAME.getName());
        Assert.assertTrue((boolean)(exp1 instanceof ASTSqrt));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)exp1, (Object)exp2);
    }

    @Test
    public void modExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.modExp(Artist.ARTIST_NAME.getExpression(), (Number)10);
        Expression exp2 = FunctionExpressionFactory.modExp(Artist.ARTIST_NAME.getName(), (Number)10);
        Expression exp3 = FunctionExpressionFactory.modExp(Artist.ARTIST_NAME.getExpression(), new ASTScalar((Object)10));
        Assert.assertTrue((boolean)(exp1 instanceof ASTMod));
        Assert.assertEquals((long)2L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)10, (Object)exp1.getOperand(1));
        Assert.assertEquals((Object)exp1, (Object)exp2);
        Assert.assertEquals((Object)exp2, (Object)exp3);
    }

    @Test
    public void concatExp() throws Exception {
        Expression exp1 = FunctionExpressionFactory.concatExp(Artist.ARTIST_NAME.getExpression(), new ASTScalar("abc"), Artist.DATE_OF_BIRTH.getExpression());
        Assert.assertTrue((boolean)(exp1 instanceof ASTConcat));
        Assert.assertEquals((long)3L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
        Assert.assertEquals((Object)"abc", (Object)exp1.getOperand(1));
        Assert.assertEquals((Object)Artist.DATE_OF_BIRTH.getExpression(), (Object)exp1.getOperand(2));
        Expression exp2 = FunctionExpressionFactory.concatExp(Artist.ARTIST_NAME.getName(), Artist.DATE_OF_BIRTH.getName(), Artist.PAINTING_ARRAY.getName());
        Assert.assertTrue((boolean)(exp2 instanceof ASTConcat));
        Assert.assertEquals((long)3L, (long)exp2.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp2.getOperand(0));
        Assert.assertEquals((Object)Artist.DATE_OF_BIRTH.getExpression(), (Object)exp2.getOperand(1));
        Assert.assertEquals((Object)Artist.PAINTING_ARRAY.getExpression(), (Object)exp2.getOperand(2));
    }

    @Test
    public void countTest() throws Exception {
        Expression exp1 = FunctionExpressionFactory.countExp();
        Assert.assertTrue((boolean)(exp1 instanceof ASTCount));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)new ASTAsterisk(), (Object)exp1.getOperand(0));
        Expression exp2 = FunctionExpressionFactory.countExp(Artist.ARTIST_NAME.getExpression());
        Assert.assertTrue((boolean)(exp2 instanceof ASTCount));
        Assert.assertEquals((long)1L, (long)exp2.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp2.getOperand(0));
    }

    @Test
    public void minTest() throws Exception {
        Expression exp1 = FunctionExpressionFactory.minExp(Artist.ARTIST_NAME.getExpression());
        Assert.assertTrue((boolean)(exp1 instanceof ASTMin));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
    }

    @Test
    public void maxTest() throws Exception {
        Expression exp1 = FunctionExpressionFactory.maxExp(Artist.ARTIST_NAME.getExpression());
        Assert.assertTrue((boolean)(exp1 instanceof ASTMax));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
    }

    @Test
    public void avgTest() throws Exception {
        Expression exp1 = FunctionExpressionFactory.avgExp(Artist.ARTIST_NAME.getExpression());
        Assert.assertTrue((boolean)(exp1 instanceof ASTAvg));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
    }

    @Test
    public void sumTest() throws Exception {
        Expression exp1 = FunctionExpressionFactory.sumExp(Artist.ARTIST_NAME.getExpression());
        Assert.assertTrue((boolean)(exp1 instanceof ASTSum));
        Assert.assertEquals((long)1L, (long)exp1.getOperandCount());
        Assert.assertEquals((Object)Artist.ARTIST_NAME.getExpression(), (Object)exp1.getOperand(0));
    }

    @Test
    public void currentDateTest() throws Exception {
        Expression exp = FunctionExpressionFactory.currentDate();
        Assert.assertTrue((boolean)(exp instanceof ASTCurrentDate));
    }

    @Test
    public void currentTimeTest() throws Exception {
        Expression exp = FunctionExpressionFactory.currentTime();
        Assert.assertTrue((boolean)(exp instanceof ASTCurrentTime));
    }

    @Test
    public void currentTimestampTest() throws Exception {
        Expression exp = FunctionExpressionFactory.currentTimestamp();
        Assert.assertTrue((boolean)(exp instanceof ASTCurrentTimestamp));
    }
}

