/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Arrays;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationVisitor;
import org.apache.cayenne.access.sqlbuilder.StringBuilderAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.BetweenNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.BitwiseNotNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.EqualNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.InNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LikeNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NotEqualNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.NotNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SelectNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TextNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ValueNode;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTAsterisk;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QualifierTranslatorTest {
    private QualifierTranslator translator;

    @Before
    public void prepareTranslator() {
        DbEntity dbEntity = new DbEntity();
        dbEntity.setName("mock");
        DbAttribute dbAttributeA = new DbAttribute();
        dbAttributeA.setName("a");
        dbEntity.addAttribute(dbAttributeA);
        DbAttribute dbAttributeB = new DbAttribute();
        dbAttributeB.setName("b");
        dbAttributeB.setPrimaryKey(true);
        dbEntity.addAttribute(dbAttributeB);
        ObjEntity entity = new ObjEntity();
        entity.setName("mock");
        ObjAttribute attribute = new ObjAttribute();
        attribute.setName("a");
        attribute.setDbAttributePath("a");
        entity.addAttribute(attribute);
        ObjAttribute attribute2 = new ObjAttribute();
        attribute2.setName("b");
        attribute2.setDbAttributePath("b");
        entity.addAttribute(attribute2);
        entity.setDbEntity(dbEntity);
        DataMap dataMap = new DataMap();
        dataMap.addDbEntity(dbEntity);
        dataMap.addObjEntity(entity);
        EntityResolver resolver = new EntityResolver();
        resolver.addDataMap(dataMap);
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withMetaData(new MockQueryMetadataBuilder().withDbEntity(dbEntity).withObjEntity(entity).build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper, resolver);
        this.translator = new QualifierTranslator(context);
    }

    @Test
    public void translateNull() {
        Assert.assertNull((Object)this.translator.translate((Expression)null));
        Assert.assertNull((Object)this.translator.translate((BaseProperty)null));
    }

    @Test
    public void translateIn() {
        Node in = this.translate("db:a in (1,2)");
        Assert.assertThat((Object)in, (Matcher)CoreMatchers.instanceOf(InNode.class));
        Assert.assertEquals((long)2L, (long)in.getChildrenCount());
        Assert.assertFalse((boolean)((InNode)in).isNot());
        Assert.assertThat((Object)in.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)in.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)in.getChild(0)).getColumn());
        Assert.assertArrayEquals((Object[])new Object[]{1, 2}, (Object[])((Object[])((ValueNode)in.getChild(1)).getValue()));
        in = this.translator.translate(ExpressionFactory.inExp("a", Arrays.asList(1, 2, 3)));
        Assert.assertThat((Object)in, (Matcher)CoreMatchers.instanceOf(InNode.class));
        Assert.assertEquals((long)2L, (long)in.getChildrenCount());
        Assert.assertFalse((boolean)((InNode)in).isNot());
        Assert.assertThat((Object)in.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)in.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)in.getChild(0)).getColumn());
        Assert.assertArrayEquals((Object[])new Object[]{1, 2, 3}, (Object[])((Object[])((ValueNode)in.getChild(1)).getValue()));
        Node notIn = this.translate("db:a not in (1,2)");
        Assert.assertThat((Object)notIn, (Matcher)CoreMatchers.instanceOf(InNode.class));
        Assert.assertEquals((long)2L, (long)notIn.getChildrenCount());
        Assert.assertTrue((boolean)((InNode)notIn).isNot());
        Assert.assertThat((Object)notIn.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)notIn.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)notIn.getChild(0)).getColumn());
        Assert.assertArrayEquals((Object[])new Object[]{1, 2}, (Object[])((Object[])((ValueNode)notIn.getChild(1)).getValue()));
    }

    @Test
    public void translateBetween() {
        Node between = this.translate("db:a between 1 and 5");
        Assert.assertThat((Object)between, (Matcher)CoreMatchers.instanceOf(BetweenNode.class));
        Assert.assertEquals((long)3L, (long)between.getChildrenCount());
        Assert.assertFalse((boolean)((BetweenNode)between).isNot());
        Assert.assertThat((Object)between.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)between.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertThat((Object)between.getChild(2), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Node notBetween = this.translate("db:b not between 2 and 6");
        Assert.assertThat((Object)notBetween, (Matcher)CoreMatchers.instanceOf(BetweenNode.class));
        Assert.assertEquals((long)3L, (long)notBetween.getChildrenCount());
        Assert.assertTrue((boolean)((BetweenNode)notBetween).isNot());
        Assert.assertThat((Object)notBetween.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)notBetween.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertThat((Object)notBetween.getChild(2), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
    }

    @Test
    public void translateNot() {
        Node not = this.translate("not true");
        Assert.assertThat((Object)not, (Matcher)CoreMatchers.instanceOf(NotNode.class));
        Assert.assertEquals((long)1L, (long)not.getChildrenCount());
        Assert.assertThat((Object)not.getChild(0), (Matcher)CoreMatchers.instanceOf(TextNode.class));
        Assert.assertEquals((Object)" 1=1", (Object)((TextNode)not.getChild(0)).getText());
    }

    @Test
    public void translateBitwiseNot() {
        Node not = this.translate("~123");
        Assert.assertThat((Object)not, (Matcher)CoreMatchers.instanceOf(BitwiseNotNode.class));
        Assert.assertEquals((long)1L, (long)not.getChildrenCount());
        Assert.assertThat((Object)not.getChild(0), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)123, (Object)((ValueNode)not.getChild(0)).getValue());
    }

    @Test
    public void translateEqual() {
        Node eq = this.translate("db:a = 123");
        Assert.assertThat((Object)eq, (Matcher)CoreMatchers.instanceOf(EqualNode.class));
        Assert.assertEquals((long)2L, (long)eq.getChildrenCount());
        Assert.assertThat((Object)eq.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)eq.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)eq.getChild(0)).getColumn());
        Assert.assertEquals((Object)123, (Object)((ValueNode)eq.getChild(1)).getValue());
        Node neq = this.translate("db:b != 321");
        Assert.assertThat((Object)neq, (Matcher)CoreMatchers.instanceOf(NotEqualNode.class));
        Assert.assertEquals((long)2L, (long)neq.getChildrenCount());
        Assert.assertThat((Object)neq.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)neq.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"b", (Object)((ColumnNode)neq.getChild(0)).getColumn());
        Assert.assertEquals((Object)321, (Object)((ValueNode)neq.getChild(1)).getValue());
    }

    @Test
    public void translateLike() {
        Node like = this.translator.translate(ExpressionFactory.likeExp("a", (Object)"abc", '~'));
        Assert.assertThat((Object)like, (Matcher)CoreMatchers.instanceOf(LikeNode.class));
        Assert.assertEquals((long)126L, (long)((LikeNode)like).getEscape());
        Assert.assertFalse((boolean)((LikeNode)like).isIgnoreCase());
        Assert.assertFalse((boolean)((LikeNode)like).isNot());
        Assert.assertEquals((long)2L, (long)like.getChildrenCount());
        Assert.assertThat((Object)like.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)like.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)like.getChild(0)).getColumn());
        Assert.assertEquals((Object)"abc", (Object)((ValueNode)like.getChild(1)).getValue());
        Node notLike = this.translate("db:a not like 'abc'");
        Assert.assertThat((Object)notLike, (Matcher)CoreMatchers.instanceOf(LikeNode.class));
        Assert.assertEquals((long)0L, (long)((LikeNode)notLike).getEscape());
        Assert.assertFalse((boolean)((LikeNode)notLike).isIgnoreCase());
        Assert.assertTrue((boolean)((LikeNode)notLike).isNot());
        Assert.assertEquals((long)2L, (long)notLike.getChildrenCount());
        Assert.assertThat((Object)notLike.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)notLike.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)notLike.getChild(0)).getColumn());
        Assert.assertEquals((Object)"abc", (Object)((ValueNode)notLike.getChild(1)).getValue());
        Node likeIgnoreCase = this.translate("db:a likeIgnoreCase 'abc'");
        Assert.assertThat((Object)likeIgnoreCase, (Matcher)CoreMatchers.instanceOf(LikeNode.class));
        Assert.assertEquals((long)0L, (long)((LikeNode)likeIgnoreCase).getEscape());
        Assert.assertTrue((boolean)((LikeNode)likeIgnoreCase).isIgnoreCase());
        Assert.assertFalse((boolean)((LikeNode)likeIgnoreCase).isNot());
        Assert.assertEquals((long)2L, (long)likeIgnoreCase.getChildrenCount());
        Assert.assertThat((Object)likeIgnoreCase.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)likeIgnoreCase.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)likeIgnoreCase.getChild(0)).getColumn());
        Assert.assertEquals((Object)"abc", (Object)((ValueNode)likeIgnoreCase.getChild(1)).getValue());
        Node notLikeIgnoreCase = this.translate("db:a not likeIgnoreCase 'abc'");
        Assert.assertThat((Object)notLikeIgnoreCase, (Matcher)CoreMatchers.instanceOf(LikeNode.class));
        Assert.assertEquals((long)0L, (long)((LikeNode)notLikeIgnoreCase).getEscape());
        Assert.assertTrue((boolean)((LikeNode)notLikeIgnoreCase).isIgnoreCase());
        Assert.assertTrue((boolean)((LikeNode)notLikeIgnoreCase).isNot());
        Assert.assertEquals((long)2L, (long)notLikeIgnoreCase.getChildrenCount());
        Assert.assertThat((Object)notLikeIgnoreCase.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)notLikeIgnoreCase.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)notLikeIgnoreCase.getChild(0)).getColumn());
        Assert.assertEquals((Object)"abc", (Object)((ValueNode)notLikeIgnoreCase.getChild(1)).getValue());
    }

    @Test
    public void translateFunctionCall() {
        Node function = this.translate("trim(a)");
        Assert.assertThat((Object)function, (Matcher)CoreMatchers.instanceOf(FunctionNode.class));
        Assert.assertEquals((Object)"TRIM", (Object)((FunctionNode)function).getFunctionName());
        Assert.assertNull((Object)((FunctionNode)function).getAlias());
        Assert.assertEquals((long)1L, (long)function.getChildrenCount());
        Assert.assertThat((Object)function.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)function.getChild(0)).getColumn());
        function = this.translate("year(a)");
        Assert.assertThat((Object)function, (Matcher)CoreMatchers.instanceOf(FunctionNode.class));
        Assert.assertEquals((Object)"YEAR", (Object)((FunctionNode)function).getFunctionName());
        Assert.assertNull((Object)((FunctionNode)function).getAlias());
        Assert.assertEquals((long)1L, (long)function.getChildrenCount());
        Assert.assertThat((Object)function.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)function.getChild(0)).getColumn());
    }

    @Test
    public void translateMathExp() {
        Node op = this.translate("1 + 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"+", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("1 - 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"-", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("1 / 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"/", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("1 * 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"*", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("-2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"-", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)1L, (long)op.getChildrenCount());
        op = this.translate("1 & 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"&", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("1 | 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"|", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("1 ^ 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"^", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("1 << 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"<<", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("1 >> 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)">>", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
    }

    @Test
    public void translateComparision() {
        Node op = this.translate("a < 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"<", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("a > 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)">", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("a <= 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"<=", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        op = this.translate("a >= 2");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)">=", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
    }

    @Test
    public void translateConst() {
        Node op = this.translate("true");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(TextNode.class));
        Assert.assertEquals((Object)" 1=1", (Object)((TextNode)op).getText());
        Assert.assertEquals((long)0L, (long)op.getChildrenCount());
        op = this.translate("false");
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(TextNode.class));
        Assert.assertEquals((Object)" 1=0", (Object)((TextNode)op).getText());
        Assert.assertEquals((long)0L, (long)op.getChildrenCount());
        op = this.translator.translate(new ASTAsterisk());
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(TextNode.class));
        Assert.assertEquals((Object)" *", (Object)((TextNode)op).getText());
        Assert.assertEquals((long)0L, (long)op.getChildrenCount());
    }

    @Test
    public void translateExists() {
        Node exists = this.translator.translate(ExpressionFactory.exists(ObjectSelect.dbQuery("mock")));
        Assert.assertThat((Object)exists, (Matcher)CoreMatchers.instanceOf(FunctionNode.class));
        Assert.assertEquals((Object)"EXISTS", (Object)((FunctionNode)exists).getFunctionName());
        Assert.assertEquals((long)1L, (long)exists.getChildrenCount());
        Assert.assertThat((Object)exists.getChild(0), (Matcher)CoreMatchers.instanceOf(SelectNode.class));
    }

    @Test
    public void translateFullObject() {
        Node fullObj = this.translator.translate(ExpressionFactory.fullObjectExp());
        Assert.assertThat((Object)fullObj, (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        ColumnNode columnNode = (ColumnNode)fullObj;
        Assert.assertEquals((Object)"b", (Object)columnNode.getColumn());
    }

    @Test(expected=CayenneRuntimeException.class)
    public void translateEnclosingObject() {
        this.translator.translate(ExpressionFactory.enclosingObjectExp(ExpressionFactory.dbPathExp("a")));
    }

    @Test
    public void translateAnd() {
        Node and = this.translate("true and false");
        Assert.assertNotNull((Object)and);
        Assert.assertThat((Object)and, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"AND", (Object)((OpExpressionNode)and).getOp());
        Assert.assertEquals((long)2L, (long)and.getChildrenCount());
        Assert.assertThat((Object)and.getChild(0), (Matcher)CoreMatchers.instanceOf(TextNode.class));
        Assert.assertEquals((Object)" 1=1", (Object)((TextNode)and.getChild(0)).getText());
        Assert.assertThat((Object)and.getChild(1), (Matcher)CoreMatchers.instanceOf(TextNode.class));
        Assert.assertEquals((Object)" 1=0", (Object)((TextNode)and.getChild(1)).getText());
    }

    @Test
    public void translateComplexAnd() {
        Node and = this.translate("a < 2 and b in (5,6) and b = 7");
        Assert.assertNotNull((Object)and);
        Assert.assertThat((Object)and, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"AND", (Object)((OpExpressionNode)and).getOp());
        Assert.assertEquals((long)3L, (long)and.getChildrenCount());
        SQLGenerationVisitor visitor = new SQLGenerationVisitor(new StringBuilderAppendable());
        and.visit(visitor);
        Assert.assertEquals((Object)" ( t0.a < 2 ) AND t0.b IN ( 5, 6) AND ( t0.b = 7 )", (Object)visitor.getSQLString());
    }

    @Test
    public void translateOr() {
        Node or = this.translate("true or false");
        Assert.assertNotNull((Object)or);
        Assert.assertThat((Object)or, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"OR", (Object)((OpExpressionNode)or).getOp());
        Assert.assertEquals((long)2L, (long)or.getChildrenCount());
        Assert.assertThat((Object)or.getChild(0), (Matcher)CoreMatchers.instanceOf(TextNode.class));
        Assert.assertThat((Object)or.getChild(1), (Matcher)CoreMatchers.instanceOf(TextNode.class));
    }

    @Test
    public void translateNullComparision() {
        Node or = this.translate("a > null");
        Assert.assertNotNull((Object)or);
        Assert.assertThat((Object)or, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)">", (Object)((OpExpressionNode)or).getOp());
        Assert.assertEquals((long)2L, (long)or.getChildrenCount());
        Assert.assertThat((Object)or.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)or.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
    }

    @Test
    public void translateComplexExp() {
        Node result = this.translate("(a >= 1 + 2 / 3 << 4) and (db:b != true)");
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)"AND", (Object)((OpExpressionNode)result).getOp());
        Assert.assertEquals((long)2L, (long)result.getChildrenCount());
        Assert.assertThat((Object)result.getChild(0), (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertThat((Object)result.getChild(1), (Matcher)CoreMatchers.instanceOf(NotEqualNode.class));
        OpExpressionNode left = (OpExpressionNode)result.getChild(0);
        Assert.assertEquals((Object)">=", (Object)left.getOp());
        Assert.assertEquals((long)2L, (long)left.getChildrenCount());
        Assert.assertThat((Object)left.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertEquals((Object)"a", (Object)((ColumnNode)left.getChild(0)).getColumn());
        Assert.assertThat((Object)left.getChild(1), (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        OpExpressionNode shift = (OpExpressionNode)left.getChild(1);
        Assert.assertEquals((Object)"<<", (Object)shift.getOp());
        Assert.assertThat((Object)shift.getChild(0), (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        OpExpressionNode plus = (OpExpressionNode)shift.getChild(0);
        Assert.assertEquals((Object)"+", (Object)plus.getOp());
        Assert.assertEquals((long)2L, (long)plus.getChildrenCount());
        Assert.assertThat((Object)plus.getChild(0), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)1, (Object)((ValueNode)plus.getChild(0)).getValue());
        Assert.assertThat((Object)plus.getChild(1), (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        OpExpressionNode div = (OpExpressionNode)plus.getChild(1);
        Assert.assertEquals((Object)"/", (Object)div.getOp());
        Assert.assertEquals((long)2L, (long)div.getChildrenCount());
        Assert.assertThat((Object)div.getChild(0), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)2, (Object)((ValueNode)div.getChild(0)).getValue());
        Assert.assertThat((Object)div.getChild(0), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)3, (Object)((ValueNode)div.getChild(1)).getValue());
        Assert.assertThat((Object)shift.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)4, (Object)((ValueNode)shift.getChild(1)).getValue());
        NotEqualNode right = (NotEqualNode)result.getChild(1);
        Assert.assertEquals((long)2L, (long)right.getChildrenCount());
        Assert.assertThat((Object)right.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertEquals((Object)"b", (Object)((ColumnNode)right.getChild(0)).getColumn());
        Assert.assertThat((Object)right.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((ValueNode)right.getChild(1)).getValue());
    }

    private Node translate(String s) {
        return this.translator.translate(ExpressionFactory.exp(s, new Object[0]));
    }
}

